/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.admin.om;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.server.JsonUtils;
import org.apache.hadoop.ozone.admin.om.OMAdmin;
import org.apache.hadoop.ozone.client.OzoneClientException;
import org.apache.hadoop.ozone.om.helpers.ServiceInfo;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import picocli.CommandLine;

@CommandLine.Command(name="roles", aliases={"getserviceroles"}, description={"List all OMs and their respective Ratis server roles"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class GetServiceRolesSubcommand
implements Callable<Void> {
    @CommandLine.ParentCommand
    private OMAdmin parent;
    @CommandLine.Option(names={"-id", "--service-id"}, description={"OM Service ID"}, required=false)
    private String omServiceId;
    @CommandLine.Option(names={"--json"}, defaultValue="false", description={"Format output as JSON"})
    private boolean json;
    private OzoneManagerProtocol ozoneManagerClient;

    @Override
    public Void call() throws Exception {
        try {
            this.ozoneManagerClient = this.parent.createOmClient(this.omServiceId);
            if (this.json) {
                this.printOmServerRolesAsJson(this.ozoneManagerClient.getServiceList());
            } else {
                this.printOmServerRoles(this.ozoneManagerClient.getServiceList());
            }
        }
        catch (OzoneClientException ex) {
            System.out.printf("Error: %s", ex.getMessage());
        }
        finally {
            if (this.ozoneManagerClient != null) {
                this.ozoneManagerClient.close();
            }
        }
        return null;
    }

    private void printOmServerRoles(List<ServiceInfo> serviceList) {
        for (ServiceInfo serviceInfo : serviceList) {
            OzoneManagerProtocolProtos.OMRoleInfo omRoleInfo = serviceInfo.getOmRoleInfo();
            if (omRoleInfo == null || serviceInfo.getNodeType() != HddsProtos.NodeType.OM) continue;
            System.out.println(omRoleInfo.getNodeId() + " : " + omRoleInfo.getServerRole() + " (" + serviceInfo.getHostname() + ")");
        }
    }

    private void printOmServerRolesAsJson(List<ServiceInfo> serviceList) throws IOException {
        ArrayList omServiceList = new ArrayList();
        for (final ServiceInfo serviceInfo : serviceList) {
            final OzoneManagerProtocolProtos.OMRoleInfo omRoleInfo = serviceInfo.getOmRoleInfo();
            if (omRoleInfo == null || serviceInfo.getNodeType() != HddsProtos.NodeType.OM) continue;
            HashMap<String, 1> omService = new HashMap<String, 1>();
            omService.put(omRoleInfo.getNodeId(), new HashMap<String, String>(){
                {
                    this.put("serverRole", omRoleInfo.getServerRole());
                    this.put("hostname", serviceInfo.getHostname());
                }
            });
            omServiceList.add(omService);
        }
        System.out.print(JsonUtils.toJsonStringWithDefaultPrettyPrinter(omServiceList));
    }
}

