/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.conf;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.conf.OzoneGetConf;
import picocli.CommandLine;

@CommandLine.Command(name="ozonemanagers", aliases={"-ozonemanagers"}, description={"gets list of ozone storage container manager nodes in the cluster"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class OzoneManagersCommandHandler
implements Callable<Void> {
    @CommandLine.ParentCommand
    private OzoneGetConf tool;

    @Override
    public Void call() throws Exception {
        OzoneConfiguration configSource = OzoneConfiguration.of((OzoneConfiguration)this.tool.getConf());
        if (OmUtils.isServiceIdsDefined((ConfigurationSource)configSource)) {
            Collection omAddresses = OmUtils.getOmHAAddressesById((ConfigurationSource)configSource).values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            for (InetSocketAddress addr : omAddresses) {
                this.tool.printOut(addr.getHostName());
            }
        } else {
            this.tool.printOut(OmUtils.getOmAddress((ConfigurationSource)configSource).getHostName());
        }
        return null;
    }
}

