/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug;

import java.net.URI;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LeaseRecoverable;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdds.cli.SubcommandWithParent;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.debug.OzoneDebug;
import picocli.CommandLine;

@CommandLine.Command(name="recover", customSynopsis={"ozone debug recover --path=<path>"}, description={"recover the lease of a specified file. Make sure to specify file system scheme if ofs:// is not the default."})
public class LeaseRecoverer
implements Callable<Void>,
SubcommandWithParent {
    @CommandLine.ParentCommand
    private OzoneDebug parent;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"--path"}, required=true, description={"Path to the file"})
    private String path;

    public String getPath() {
        return this.path;
    }

    public void setPath(String dbPath) {
        this.path = dbPath;
    }

    public Class<?> getParentType() {
        return OzoneDebug.class;
    }

    @Override
    public Void call() throws Exception {
        OzoneConfiguration configuration = new OzoneConfiguration();
        URI uri = URI.create(this.path);
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)configuration);
        if (!(fs instanceof LeaseRecoverable)) {
            throw new IllegalArgumentException("Unsupported file system: " + fs.getScheme());
        }
        ((LeaseRecoverable)fs).recoverLease(new Path(uri));
        System.out.println("Lease recovery SUCCEEDED on " + uri);
        return null;
    }
}

