/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug.container;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.container.replication.CopyContainerCompression;
import org.apache.hadoop.ozone.container.replication.OnDemandContainerReplicationSource;
import org.apache.hadoop.ozone.debug.container.ContainerCommands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="export", description={"Export one container to a tarball"})
public class ExportSubcommand
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(ExportSubcommand.class);
    @CommandLine.ParentCommand
    private ContainerCommands parent;
    @CommandLine.Option(names={"--container"}, required=true, description={"Container Id"})
    private long containerId;
    @CommandLine.Option(names={"--dest"}, defaultValue="/tmp", description={"Destination directory to hold exported container files"})
    private String destination;
    @CommandLine.Option(names={"--count"}, description={"Count of containers to export"})
    private long containerCount = 1L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Void call() throws Exception {
        this.parent.loadContainersFromVolumes();
        OnDemandContainerReplicationSource replicationSource = new OnDemandContainerReplicationSource(this.parent.getController());
        int i = 0;
        while ((long)i < this.containerCount) {
            block18: {
                File destinationFile;
                block19: {
                    FileOutputStream fos;
                    block20: {
                        replicationSource.prepare(this.containerId);
                        destinationFile = new File(this.destination, "container-" + this.containerId + ".tar");
                        fos = new FileOutputStream(destinationFile);
                        Throwable throwable = null;
                        try {
                            block17: {
                                try {
                                    replicationSource.copyData(this.containerId, (OutputStream)fos, CopyContainerCompression.NO_COMPRESSION);
                                }
                                catch (StorageContainerException e) {
                                    if (e.getResult() != ContainerProtos.Result.CONTAINER_NOT_FOUND) break block17;
                                    if (fos != null) {
                                        if (throwable != null) {
                                            try {
                                                fos.close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                            break block18;
                                        } else {
                                            fos.close();
                                        }
                                    }
                                    break block18;
                                }
                            }
                            if (fos == null) break block19;
                            if (throwable == null) break block20;
                        }
                        catch (Throwable throwable4) {
                            try {
                                throwable = throwable4;
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                if (fos == null) throw throwable5;
                                if (throwable == null) {
                                    fos.close();
                                    throw throwable5;
                                }
                                try {
                                    fos.close();
                                    throw throwable5;
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                    throw throwable5;
                                }
                            }
                        }
                        try {
                            fos.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        break block19;
                    }
                    fos.close();
                }
                LOG.info("Container {} is exported to {}", (Object)this.containerId, (Object)destinationFile);
                ++this.containerId;
            }
            ++i;
        }
        return null;
    }
}

