/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.fs.Syncable;
import org.apache.hadoop.fs.impl.StoreImplementationUtils;
import org.apache.hadoop.ozone.client.io.OzoneDataStreamOutput;

public class ContentGenerator {
    private long keySize;
    private int bufferSize;
    private final int copyBufferSize;
    private final byte[] buffer;
    private SyncOptions flushOrSync;

    ContentGenerator(long keySize, int bufferSize) {
        this(keySize, bufferSize, bufferSize);
    }

    ContentGenerator(long keySize, int bufferSize, int copyBufferSize) {
        this.keySize = keySize;
        this.bufferSize = bufferSize;
        this.copyBufferSize = copyBufferSize;
        this.buffer = RandomStringUtils.randomAscii((int)bufferSize).getBytes(StandardCharsets.UTF_8);
        this.flushOrSync = SyncOptions.NONE;
    }

    ContentGenerator(long keySize, int bufferSize, int copyBufferSize, SyncOptions flushOrSync) {
        this(keySize, bufferSize, copyBufferSize);
        this.flushOrSync = flushOrSync;
    }

    public void write(OutputStream outputStream) throws IOException {
        for (long nrRemaining = this.keySize; nrRemaining > 0L; nrRemaining -= (long)this.bufferSize) {
            int i;
            int curSize = (int)Math.min((long)this.bufferSize, nrRemaining);
            if (this.copyBufferSize == 1) {
                for (i = 0; i < curSize; ++i) {
                    outputStream.write(this.buffer[i]);
                    this.doFlushOrSync(outputStream);
                }
                continue;
            }
            for (i = 0; i < curSize; i += this.copyBufferSize) {
                outputStream.write(this.buffer, i, Math.min(this.copyBufferSize, curSize - i));
                this.doFlushOrSync(outputStream);
            }
        }
    }

    private void doFlushOrSync(OutputStream outputStream) throws IOException {
        switch (this.flushOrSync) {
            case NONE: {
                break;
            }
            case HFLUSH: {
                if (!StoreImplementationUtils.hasCapability((OutputStream)outputStream, (String)"hsync")) break;
                ((Syncable)outputStream).hflush();
                break;
            }
            case HSYNC: {
                if (!StoreImplementationUtils.hasCapability((OutputStream)outputStream, (String)"hsync")) break;
                ((Syncable)outputStream).hsync();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported sync option" + (Object)((Object)this.flushOrSync));
            }
        }
    }

    public void write(OzoneDataStreamOutput out) throws IOException {
        for (long nrRemaining = this.keySize; nrRemaining > 0L; nrRemaining -= (long)this.bufferSize) {
            int curSize = (int)Math.min((long)this.bufferSize, nrRemaining);
            for (int i = 0; i < curSize; i += this.copyBufferSize) {
                ByteBuffer bb = ByteBuffer.wrap(this.buffer, i, Math.min(this.copyBufferSize, curSize - i));
                out.write(bb);
            }
        }
        out.close();
    }

    @VisibleForTesting
    byte[] getBuffer() {
        return this.buffer;
    }

    static enum SyncOptions {
        NONE,
        HFLUSH,
        HSYNC;

    }
}

