/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.acl;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.client.ObjectStore;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import picocli.CommandLine;

public class AclOption
implements CommandLine.ITypeConverter<OzoneAcl> {
    @CommandLine.Option(names={"--acls", "--acl", "-al", "-a"}, split=",", required=true, converter={AclOption.class}, description={"Comma separated ACL list:\nExample: user:user2:a OR user:user1:rw,group:hadoop:a\nr = READ, w = WRITE, c = CREATE, d = DELETE, l = LIST, a = ALL, n = NONE, x = READ_ACL, y = WRITE_ACL."})
    private OzoneAcl[] values;

    private List<OzoneAcl> getAclList() {
        return ImmutableList.copyOf((Object[])this.values);
    }

    public void addTo(OzoneObj obj, ObjectStore objectStore, PrintStream out) throws IOException {
        for (OzoneAcl acl : this.getAclList()) {
            boolean result = objectStore.addAcl(obj, acl);
            String message = result ? "ACL %s added successfully.%n" : "ACL %s already exists.%n";
            out.printf(message, acl);
        }
    }

    public void removeFrom(OzoneObj obj, ObjectStore objectStore, PrintStream out) throws IOException {
        for (OzoneAcl acl : this.getAclList()) {
            boolean result = objectStore.removeAcl(obj, acl);
            String message = result ? "ACL %s removed successfully.%n" : "ACL %s doesn't exist.%n";
            out.printf(message, acl);
        }
    }

    public void setOn(OzoneObj obj, ObjectStore objectStore, PrintStream out) throws IOException {
        objectStore.setAcl(obj, this.getAclList());
        out.println("ACLs set successfully.");
    }

    public OzoneAcl convert(String value) {
        return OzoneAcl.parseAcl((String)value);
    }
}

