/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.tenant;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.tenant.TenantHandler;
import picocli.CommandLine;

@CommandLine.Command(name="revoke-admin", aliases={"revokeadmin"}, description={"Revoke admin role from accessIds in a tenant"})
public class TenantRevokeAdminHandler
extends TenantHandler {
    @CommandLine.Parameters(description={"Access ID"}, arity="1..1")
    private String accessId;
    @CommandLine.Option(names={"-t", "--tenant"}, description={"Tenant name"})
    private String tenantId;

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        client.getObjectStore().tenantRevokeAdmin(this.accessId, this.tenantId);
        if (this.isVerbose()) {
            JsonObject obj = new JsonObject();
            obj.addProperty("accessId", this.accessId);
            obj.addProperty("tenantId", this.tenantId);
            obj.addProperty("isAdmin", Boolean.valueOf(false));
            obj.addProperty("isDelegatedAdmin", Boolean.valueOf(false));
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            this.out().println(gson.toJson((JsonElement)obj));
        }
    }
}

