/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.volume;

import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneKey;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.volume.VolumeHandler;
import picocli.CommandLine;

@CommandLine.Command(name="delete", description={"deletes a volume"})
public class DeleteVolumeHandler
extends VolumeHandler {
    @CommandLine.Option(names={"-r"}, description={"Delete volume recursively"})
    private boolean bRecursive;
    @CommandLine.Option(names={"-t", "--threads", "--thread"}, description={"Number of threads used to execute recursive delete"})
    private int threadNo = 10;
    @CommandLine.Option(names={"-y", "--yes"}, description={"Continue without interactive user confirmation"})
    private boolean yes;
    private ExecutorService executor;
    private List<String> bucketIdList = new ArrayList<String>();
    private AtomicInteger cleanedBucketCounter = new AtomicInteger();
    private int totalBucketCount;
    private OzoneVolume vol;
    private AtomicInteger numberOfBucketsCleaned = new AtomicInteger(0);
    private volatile Throwable exception;
    private static final int MAX_KEY_DELETE_BATCH_SIZE = 1000;
    private String omServiceId;

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        String volumeName = address.getVolumeName();
        this.omServiceId = address.getOmServiceId((ConfigurationSource)this.getConf());
        try {
            if (this.bRecursive) {
                if (!this.yes) {
                    this.out().print("This command will delete volume recursively.\nThere is no recovery option after using this command, and no trash for FSO buckets.\nDelay is expected running this command.\nEnter 'yes' to proceed': ");
                    this.out().flush();
                    Scanner scanner = new Scanner(new InputStreamReader(System.in, StandardCharsets.UTF_8));
                    String confirmation = scanner.next().trim().toLowerCase();
                    if (!confirmation.equals("yes")) {
                        this.out().println("Operation cancelled.");
                        return;
                    }
                }
                this.vol = client.getObjectStore().getVolume(volumeName);
                this.deleteVolumeRecursive();
            }
        }
        catch (InterruptedException e) {
            this.out().printf("Exception while deleting volume recursively%n", new Object[0]);
            return;
        }
        client.getObjectStore().deleteVolume(volumeName);
        this.out().printf("Volume %s is deleted%n", volumeName);
    }

    private void deleteVolumeRecursive() throws InterruptedException {
        Iterator bucketIterator = this.vol.listBuckets(null);
        while (bucketIterator.hasNext()) {
            OzoneBucket bucket = (OzoneBucket)bucketIterator.next();
            this.bucketIdList.add(bucket.getName());
            ++this.totalBucketCount;
        }
        this.doCleanBuckets();
    }

    private boolean cleanOBSBucket(OzoneBucket bucket) {
        ArrayList<String> keys = new ArrayList<String>();
        try {
            if (!bucket.isLink()) {
                Iterator iterator = bucket.listKeys(null);
                while (iterator.hasNext()) {
                    keys.add(((OzoneKey)iterator.next()).getName());
                    if (1000 != keys.size()) continue;
                    bucket.deleteKeys(keys);
                    keys.clear();
                }
                if (keys.size() > 0) {
                    bucket.deleteKeys(keys);
                }
            }
            this.vol.deleteBucket(bucket.getName());
            this.numberOfBucketsCleaned.getAndIncrement();
            return true;
        }
        catch (Exception e) {
            LOG.error("Could not clean bucket ", (Throwable)e);
            return false;
        }
    }

    private boolean cleanFSBucket(OzoneBucket bucket) {
        try {
            String hostPrefix = "ofs://" + this.omServiceId + "/";
            String ofsPrefix = hostPrefix + this.vol.getName() + "/" + bucket.getName();
            Path path = new Path(ofsPrefix);
            OzoneConfiguration clientConf = new OzoneConfiguration((Configuration)this.getConf());
            clientConf.set("fs.defaultFS", hostPrefix);
            FileSystem fs = FileSystem.get((Configuration)clientConf);
            if (!fs.delete(path, true)) {
                throw new IOException("Failed to delete bucket");
            }
            this.numberOfBucketsCleaned.getAndIncrement();
            return true;
        }
        catch (Exception e) {
            this.exception = e;
            LOG.error("Could not clean bucket ", (Throwable)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doCleanBuckets() throws InterruptedException {
        this.executor = Executors.newFixedThreadPool(this.threadNo);
        for (int i = 0; i < this.threadNo; ++i) {
            this.executor.execute(new BucketCleaner());
        }
        try {
            while (this.numberOfBucketsCleaned.get() != this.totalBucketCount && this.exception == null) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            LOG.error("Failed to wait until all Buckets are cleaned", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        this.executor.shutdown();
        this.executor.awaitTermination(Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    private class BucketCleaner
    implements Runnable {
        private BucketCleaner() {
        }

        @Override
        public void run() {
            int i;
            block6: while ((i = DeleteVolumeHandler.this.cleanedBucketCounter.getAndIncrement()) < DeleteVolumeHandler.this.totalBucketCount) {
                try {
                    OzoneBucket bucket = DeleteVolumeHandler.this.vol.getBucket((String)DeleteVolumeHandler.this.bucketIdList.get(i));
                    switch (bucket.getBucketLayout()) {
                        case FILE_SYSTEM_OPTIMIZED: 
                        case LEGACY: {
                            if (DeleteVolumeHandler.this.cleanFSBucket(bucket)) continue block6;
                            throw new RuntimeException("Failed to clean bucket");
                        }
                        case OBJECT_STORE: {
                            if (DeleteVolumeHandler.this.cleanOBSBucket(bucket)) break;
                            throw new RuntimeException("Failed to clean bucket");
                        }
                    }
                    throw new RuntimeException("Invalid bucket layout");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

