/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.rocksdiff;

public class CompactionNode {
    private final String fileName;
    private final long snapshotGeneration;
    private final long totalNumberOfKeys;
    private long cumulativeKeysReverseTraversal;
    private final String startKey;
    private final String endKey;
    private final String columnFamily;

    public CompactionNode(String file, long numKeys, long seqNum, String startKey, String endKey, String columnFamily) {
        this.fileName = file;
        this.totalNumberOfKeys = numKeys;
        this.snapshotGeneration = seqNum;
        this.cumulativeKeysReverseTraversal = 0L;
        this.startKey = startKey;
        this.endKey = endKey;
        this.columnFamily = columnFamily;
    }

    public String toString() {
        return String.format("Node{%s}", this.fileName);
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getSnapshotGeneration() {
        return this.snapshotGeneration;
    }

    public long getTotalNumberOfKeys() {
        return this.totalNumberOfKeys;
    }

    public long getCumulativeKeysReverseTraversal() {
        return this.cumulativeKeysReverseTraversal;
    }

    public String getStartKey() {
        return this.startKey;
    }

    public String getEndKey() {
        return this.endKey;
    }

    public String getColumnFamily() {
        return this.columnFamily;
    }

    public void setCumulativeKeysReverseTraversal(long cumulativeKeysReverseTraversal) {
        this.cumulativeKeysReverseTraversal = cumulativeKeysReverseTraversal;
    }

    public void addCumulativeKeysReverseTraversal(long diff) {
        this.cumulativeKeysReverseTraversal += diff;
    }
}

