/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.fileindex;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.utils.StringUtils;

public class FileIndexOptions {
    public static final String FILE_INDEX = "file-index";
    public static final String COLUMNS = "columns";
    private final long fileIndexInManifestThreshold;
    private final Map<Column, Map<String, Options>> indexTypeOptions = new HashMap<Column, Map<String, Options>>();
    private final Map<Column, Map<String, Options>> topLevelMapColumnOptions = new HashMap<Column, Map<String, Options>>();

    public FileIndexOptions() {
        this(new CoreOptions(new Options()));
    }

    public FileIndexOptions(CoreOptions coreOptions) {
        this.fileIndexInManifestThreshold = coreOptions.fileIndexInManifestThreshold();
        this.setupOptions(coreOptions);
    }

    private void setupOptions(CoreOptions coreOptions) {
        String key;
        String fileIndexPrefix = "file-index.";
        String fileIndexColumnSuffix = ".columns";
        HashMap<String, String> optionMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : coreOptions.toMap().entrySet()) {
            key = entry.getKey();
            if (!key.startsWith(fileIndexPrefix)) continue;
            if (key.endsWith(fileIndexColumnSuffix)) {
                String[] names;
                String indexType = key.substring(fileIndexPrefix.length(), key.length() - fileIndexColumnSuffix.length());
                for (String name : names = entry.getValue().split(",")) {
                    if (StringUtils.isNullOrWhitespaceOnly(name)) {
                        throw new IllegalArgumentException("Wrong option in " + key + ", should not have empty column");
                    }
                    this.computeIfAbsent(name.trim(), indexType);
                }
                continue;
            }
            optionMap.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : optionMap.entrySet()) {
            key = entry.getKey();
            String[] kv = key.substring(fileIndexPrefix.length()).split("\\.");
            if (kv.length != 3) continue;
            String indexType = kv[0];
            String cname = kv[1];
            String opkey = kv[2];
            if (this.get(cname, indexType) != null) {
                this.get(cname, indexType).set(opkey, entry.getValue());
                continue;
            }
            if (this.getMapTopLevelOptions(cname, indexType) != null) {
                this.getMapTopLevelOptions(cname, indexType).set(opkey, entry.getValue());
                continue;
            }
            throw new IllegalArgumentException("Wrong option in \"" + key + "\", can't found column \"" + cname + "\" in \"" + fileIndexPrefix + indexType + fileIndexColumnSuffix + "\"");
        }
    }

    private void computeIfAbsent(String column, String indexType) {
        Optional<Integer> nestedColumnPosition = FileIndexOptions.topLevelIndexOfNested(column);
        if (nestedColumnPosition.isPresent()) {
            int position = nestedColumnPosition.get();
            String columnName = column.substring(0, position);
            String nestedName = column.substring(position + 1, column.length() - 1);
            this.indexTypeOptions.computeIfAbsent(new Column(columnName, nestedName), (? super K c) -> new HashMap()).computeIfAbsent(indexType, (? super K i) -> new Options());
            this.topLevelMapColumnOptions.computeIfAbsent(new Column(columnName), (? super K c) -> new HashMap()).computeIfAbsent(indexType, (? super K i) -> new Options());
        } else {
            this.indexTypeOptions.computeIfAbsent(new Column(column), (? super K c) -> new HashMap()).computeIfAbsent(indexType, (? super K i) -> new Options());
        }
    }

    private Options get(String column, String indexType) {
        Column columnKey;
        Optional<Integer> nestedColumnPosition = FileIndexOptions.topLevelIndexOfNested(column);
        if (nestedColumnPosition.isPresent()) {
            int position = nestedColumnPosition.get();
            String columnName = column.substring(0, position);
            String nestedName = column.substring(position + 1, column.length() - 1);
            columnKey = new Column(columnName, nestedName);
        } else {
            columnKey = new Column(column);
        }
        return Optional.ofNullable(this.indexTypeOptions.getOrDefault(columnKey, null)).map(x -> (Options)x.get(indexType)).orElse(null);
    }

    public Options getMapTopLevelOptions(String column, String indexType) {
        return Optional.ofNullable(this.topLevelMapColumnOptions.getOrDefault(new Column(column), null)).map(x -> (Options)x.get(indexType)).orElseThrow(() -> new IllegalArgumentException("Can't find top level column options for map type: " + column + " " + indexType));
    }

    public boolean isEmpty() {
        return this.indexTypeOptions.isEmpty();
    }

    public long fileIndexInManifestThreshold() {
        return this.fileIndexInManifestThreshold;
    }

    public Set<Map.Entry<Column, Map<String, Options>>> entrySet() {
        return this.indexTypeOptions.entrySet();
    }

    public static Optional<Integer> topLevelIndexOfNested(String column) {
        int start = column.indexOf(91);
        if (start != -1 && column.endsWith("]")) {
            return Optional.of(start);
        }
        return Optional.empty();
    }

    public static class Column {
        private final String columnName;
        private final String nestedColumnName;
        private final boolean isNestedColumn;

        public Column(String columnName) {
            this.columnName = columnName;
            this.nestedColumnName = null;
            this.isNestedColumn = false;
        }

        public Column(String columnName, String nestedColumnName) {
            this.columnName = columnName;
            this.nestedColumnName = nestedColumnName;
            this.isNestedColumn = true;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getNestedColumnName() {
            if (!this.isNestedColumn) {
                throw new RuntimeException("Column " + this.columnName + " is not nested column in options.");
            }
            return this.nestedColumnName;
        }

        public boolean isNestedColumn() {
            return this.isNestedColumn;
        }

        public int hashCode() {
            return Arrays.hashCode(new Object[]{this.columnName, this.nestedColumnName, this.isNestedColumn});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Column)) {
                return false;
            }
            Column that = (Column)obj;
            return Objects.equals(this.columnName, that.columnName) && Objects.equals(this.nestedColumnName, that.nestedColumnName) && this.isNestedColumn == that.isNestedColumn;
        }
    }
}

