/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.rest.auth;

import java.io.File;
import org.apache.paimon.rest.RESTApi;
import org.apache.paimon.rest.auth.DLFToken;
import org.apache.paimon.rest.auth.DLFTokenLoader;
import org.apache.paimon.utils.FileReadUtils;

public class DLFLocalFileTokenLoader
implements DLFTokenLoader {
    private final String tokenFilePath;

    public DLFLocalFileTokenLoader(String tokenFilePath) {
        this.tokenFilePath = tokenFilePath;
    }

    @Override
    public DLFToken loadToken() {
        return DLFLocalFileTokenLoader.readToken(this.tokenFilePath);
    }

    @Override
    public String description() {
        return this.tokenFilePath;
    }

    protected static DLFToken readToken(String tokenFilePath) {
        Exception lastException = null;
        for (int retry = 1; retry <= 5; ++retry) {
            try {
                String tokenStr = FileReadUtils.readFileUtf8(new File(tokenFilePath));
                return RESTApi.fromJson(tokenStr, DLFToken.class);
            }
            catch (Exception e) {
                lastException = e;
                try {
                    Thread.sleep((long)retry * 1000L);
                    continue;
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e2);
                }
            }
        }
        throw new RuntimeException(lastException);
    }
}

