/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.arrow;

import java.time.ZoneId;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.BinaryType;
import org.apache.paimon.types.BooleanType;
import org.apache.paimon.types.CharType;
import org.apache.paimon.types.DataTypeVisitor;
import org.apache.paimon.types.DateType;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.DoubleType;
import org.apache.paimon.types.FloatType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.SmallIntType;
import org.apache.paimon.types.TimeType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.types.TinyIntType;
import org.apache.paimon.types.VarBinaryType;
import org.apache.paimon.types.VarCharType;

public class ArrowFieldTypeConversion {
    public static final ArrowFieldTypeVisitor ARROW_FIELD_TYPE_VISITOR = new ArrowFieldTypeVisitor();

    public static class ArrowFieldTypeVisitor
    implements DataTypeVisitor<FieldType> {
        public FieldType visit(CharType charType) {
            return new FieldType(charType.isNullable(), Types.MinorType.VARCHAR.getType(), null);
        }

        public FieldType visit(VarCharType varCharType) {
            return new FieldType(varCharType.isNullable(), Types.MinorType.VARCHAR.getType(), null);
        }

        public FieldType visit(BooleanType booleanType) {
            return new FieldType(booleanType.isNullable(), Types.MinorType.BIT.getType(), null);
        }

        public FieldType visit(BinaryType binaryType) {
            return new FieldType(binaryType.isNullable(), Types.MinorType.VARBINARY.getType(), null);
        }

        public FieldType visit(VarBinaryType varBinaryType) {
            return new FieldType(varBinaryType.isNullable(), Types.MinorType.VARBINARY.getType(), null);
        }

        public FieldType visit(DecimalType decimalType) {
            return new FieldType(decimalType.isNullable(), (ArrowType)new ArrowType.Decimal(decimalType.getPrecision(), decimalType.getScale(), 128), null);
        }

        public FieldType visit(TinyIntType tinyIntType) {
            return new FieldType(tinyIntType.isNullable(), Types.MinorType.TINYINT.getType(), null);
        }

        public FieldType visit(SmallIntType smallIntType) {
            return new FieldType(smallIntType.isNullable(), Types.MinorType.SMALLINT.getType(), null);
        }

        public FieldType visit(IntType intType) {
            return new FieldType(intType.isNullable(), Types.MinorType.INT.getType(), null);
        }

        public FieldType visit(BigIntType bigIntType) {
            return new FieldType(bigIntType.isNullable(), Types.MinorType.BIGINT.getType(), null);
        }

        public FieldType visit(FloatType floatType) {
            return new FieldType(floatType.isNullable(), Types.MinorType.FLOAT4.getType(), null);
        }

        public FieldType visit(DoubleType doubleType) {
            return new FieldType(doubleType.isNullable(), Types.MinorType.FLOAT8.getType(), null);
        }

        public FieldType visit(DateType dateType) {
            return new FieldType(dateType.isNullable(), Types.MinorType.DATEDAY.getType(), null);
        }

        public FieldType visit(TimeType timeType) {
            return new FieldType(timeType.isNullable(), Types.MinorType.TIMEMILLI.getType(), null);
        }

        public FieldType visit(TimestampType timestampType) {
            int precision = timestampType.getPrecision();
            TimeUnit timeUnit = this.getTimeUnit(precision);
            ArrowType.Timestamp arrowType = new ArrowType.Timestamp(timeUnit, null);
            return new FieldType(timestampType.isNullable(), (ArrowType)arrowType, null);
        }

        public FieldType visit(LocalZonedTimestampType localZonedTimestampType) {
            int precision = localZonedTimestampType.getPrecision();
            TimeUnit timeUnit = this.getTimeUnit(precision);
            ArrowType.Timestamp arrowType = new ArrowType.Timestamp(timeUnit, ZoneId.systemDefault().toString());
            return new FieldType(localZonedTimestampType.isNullable(), (ArrowType)arrowType, null);
        }

        private TimeUnit getTimeUnit(int precision) {
            if (precision == 0) {
                return TimeUnit.SECOND;
            }
            if (precision >= 1 && precision <= 3) {
                return TimeUnit.MILLISECOND;
            }
            if (precision >= 4 && precision <= 6) {
                return TimeUnit.MICROSECOND;
            }
            return TimeUnit.NANOSECOND;
        }

        public FieldType visit(ArrayType arrayType) {
            return new FieldType(arrayType.isNullable(), Types.MinorType.LIST.getType(), null);
        }

        public FieldType visit(MultisetType multisetType) {
            throw new UnsupportedOperationException("Doesn't support MultisetType.");
        }

        public FieldType visit(MapType mapType) {
            return new FieldType(mapType.isNullable(), (ArrowType)new ArrowType.Map(false), null);
        }

        public FieldType visit(RowType rowType) {
            return new FieldType(rowType.isNullable(), Types.MinorType.STRUCT.getType(), null);
        }
    }
}

