/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.arrow;

import java.io.IOException;
import java.io.OutputStream;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.arrow.c.ArrowArray;
import org.apache.arrow.c.ArrowSchema;
import org.apache.arrow.c.Data;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.paimon.arrow.ArrowFieldTypeConversion;
import org.apache.paimon.arrow.vector.ArrowCStruct;
import org.apache.paimon.arrow.writer.ArrowFieldWriter;
import org.apache.paimon.arrow.writer.ArrowFieldWriterFactory;
import org.apache.paimon.arrow.writer.ArrowFieldWriterFactoryVisitor;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeVisitor;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.RowType;

public class ArrowUtils {
    public static VectorSchemaRoot createVectorSchemaRoot(RowType rowType, BufferAllocator allocator) {
        return ArrowUtils.createVectorSchemaRoot(rowType, allocator, true);
    }

    public static VectorSchemaRoot createVectorSchemaRoot(RowType rowType, BufferAllocator allocator, boolean allowUpperCase) {
        List fields = rowType.getFields().stream().map(f -> ArrowUtils.toArrowField(allowUpperCase ? f.name() : f.name().toLowerCase(), f.type())).collect(Collectors.toList());
        return VectorSchemaRoot.create((Schema)new Schema(fields), (BufferAllocator)allocator);
    }

    public static FieldVector createVector(DataField dataField, BufferAllocator allocator, boolean allowUpperCase) {
        return ArrowUtils.toArrowField(allowUpperCase ? dataField.name() : dataField.name().toLowerCase(), dataField.type()).createVector(allocator);
    }

    public static Field toArrowField(String fieldName, DataType dataType) {
        FieldType fieldType = (FieldType)dataType.accept((DataTypeVisitor)ArrowFieldTypeConversion.ARROW_FIELD_TYPE_VISITOR);
        List<Object> children = null;
        if (dataType instanceof ArrayType) {
            children = Collections.singletonList(ArrowUtils.toArrowField("$data$", ((ArrayType)dataType).getElementType()));
        } else if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            children = Collections.singletonList(new Field("entries", new FieldType(false, Types.MinorType.STRUCT.getType(), null), Arrays.asList(ArrowUtils.toArrowField("key", mapType.getKeyType().notNull()), ArrowUtils.toArrowField("value", mapType.getValueType().notNull()))));
        } else if (dataType instanceof RowType) {
            RowType rowType = (RowType)dataType;
            children = rowType.getFields().stream().map(f -> ArrowUtils.toArrowField(f.name(), f.type())).collect(Collectors.toList());
        }
        return new Field(fieldName, fieldType, children);
    }

    public static ArrowFieldWriter[] createArrowFieldWriters(VectorSchemaRoot vectorSchemaRoot, RowType rowType) {
        ArrowFieldWriter[] fieldWriters = new ArrowFieldWriter[rowType.getFieldCount()];
        List vectors = vectorSchemaRoot.getFieldVectors();
        for (int i = 0; i < rowType.getFieldCount(); ++i) {
            fieldWriters[i] = ((ArrowFieldWriterFactory)rowType.getTypeAt(i).accept((DataTypeVisitor)ArrowFieldWriterFactoryVisitor.INSTANCE)).create((FieldVector)vectors.get(i));
        }
        return fieldWriters;
    }

    public static long timestampToEpoch(Timestamp timestamp, int precision, @Nullable ZoneId castZoneId) {
        return castZoneId == null ? ArrowUtils.nonCastedTimestampToEpoch(timestamp, precision) : ArrowUtils.zoneCastedTimestampZoneCastToEpoch(timestamp, precision, castZoneId);
    }

    public static ArrowCStruct serializeToCStruct(VectorSchemaRoot vsr, ArrowArray array, ArrowSchema schema) {
        BufferAllocator bufferAllocator = vsr.getVector(0).getAllocator();
        Data.exportVectorSchemaRoot((BufferAllocator)bufferAllocator, (VectorSchemaRoot)vsr, null, (ArrowArray)array, (ArrowSchema)schema);
        return ArrowCStruct.of(array, schema);
    }

    public static void serializeToIpc(VectorSchemaRoot vsr, OutputStream out) {
        try (ArrowStreamWriter writer = new ArrowStreamWriter(vsr, null, out);){
            writer.start();
            writer.writeBatch();
            writer.end();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize VectorSchemaRoot to IPC", e);
        }
    }

    private static long nonCastedTimestampToEpoch(Timestamp timestamp, int precision) {
        if (precision == 0) {
            return timestamp.getMillisecond() / 1000L;
        }
        if (precision >= 1 && precision <= 3) {
            return timestamp.getMillisecond();
        }
        if (precision >= 4 && precision <= 6) {
            return timestamp.toMicros();
        }
        return timestamp.getMillisecond() * 1000000L + (long)timestamp.getNanoOfMillisecond();
    }

    private static long zoneCastedTimestampZoneCastToEpoch(Timestamp timestamp, int precision, ZoneId castZoneId) {
        Instant instant = timestamp.toLocalDateTime().atZone(castZoneId).toInstant();
        if (precision == 0) {
            return instant.getEpochSecond();
        }
        if (precision >= 1 && precision <= 3) {
            return instant.getEpochSecond() * 1000L + (long)(instant.getNano() / 1000000);
        }
        if (precision >= 4 && precision <= 6) {
            return instant.getEpochSecond() * 1000000L + (long)(instant.getNano() / 1000);
        }
        return instant.getEpochSecond() * 1000000000L + (long)instant.getNano();
    }
}

