/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.arrow.converter;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeStampVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.data.columnar.ArrayColumnVector;
import org.apache.paimon.data.columnar.BooleanColumnVector;
import org.apache.paimon.data.columnar.ByteColumnVector;
import org.apache.paimon.data.columnar.BytesColumnVector;
import org.apache.paimon.data.columnar.ColumnVector;
import org.apache.paimon.data.columnar.ColumnarArray;
import org.apache.paimon.data.columnar.ColumnarMap;
import org.apache.paimon.data.columnar.ColumnarRow;
import org.apache.paimon.data.columnar.DecimalColumnVector;
import org.apache.paimon.data.columnar.DoubleColumnVector;
import org.apache.paimon.data.columnar.FloatColumnVector;
import org.apache.paimon.data.columnar.IntColumnVector;
import org.apache.paimon.data.columnar.LongColumnVector;
import org.apache.paimon.data.columnar.MapColumnVector;
import org.apache.paimon.data.columnar.RowColumnVector;
import org.apache.paimon.data.columnar.ShortColumnVector;
import org.apache.paimon.data.columnar.TimestampColumnVector;
import org.apache.paimon.data.columnar.VectorizedColumnBatch;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.BinaryType;
import org.apache.paimon.types.BooleanType;
import org.apache.paimon.types.CharType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeVisitor;
import org.apache.paimon.types.DateType;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.DoubleType;
import org.apache.paimon.types.FloatType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.SmallIntType;
import org.apache.paimon.types.TimeType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.types.TinyIntType;
import org.apache.paimon.types.VarBinaryType;
import org.apache.paimon.types.VarCharType;

public interface Arrow2PaimonVectorConverter {
    public static Arrow2PaimonVectorConverter construct(DataType type) {
        return (Arrow2PaimonVectorConverter)type.accept((DataTypeVisitor)Arrow2PaimonVectorConvertorVisitor.INSTANCE);
    }

    public ColumnVector convertVector(FieldVector var1);

    public static class Arrow2PaimonVectorConvertorVisitor
    implements DataTypeVisitor<Arrow2PaimonVectorConverter> {
        private static final Arrow2PaimonVectorConvertorVisitor INSTANCE = new Arrow2PaimonVectorConvertorVisitor();

        public Arrow2PaimonVectorConverter visit(CharType charType) {
            return vector -> new BytesColumnVector(){

                public boolean isNullAt(int index) {
                    return vector.isNull(index);
                }

                public BytesColumnVector.Bytes getBytes(int index) {
                    final byte[] bytes = vector instanceof FixedSizeBinaryVector ? ((FixedSizeBinaryVector)vector).get(index) : ((VarCharVector)vector).get(index);
                    return new BytesColumnVector.Bytes(bytes, 0, bytes.length){

                        public byte[] getBytes() {
                            return bytes;
                        }
                    };
                }
            };
        }

        public Arrow2PaimonVectorConverter visit(VarCharType varCharType) {
            return vector -> new BytesColumnVector(){

                public boolean isNullAt(int index) {
                    return vector.isNull(index);
                }

                public BytesColumnVector.Bytes getBytes(int index) {
                    final byte[] bytes = ((VarCharVector)vector).get(index);
                    return new BytesColumnVector.Bytes(bytes, 0, bytes.length){

                        public byte[] getBytes() {
                            return bytes;
                        }
                    };
                }
            };
        }

        public Arrow2PaimonVectorConverter visit(BooleanType booleanType) {
            return vector -> new BooleanColumnVector(){

                public boolean isNullAt(int index) {
                    return vector.isNull(index);
                }

                public boolean getBoolean(int index) {
                    return ((BitVector)vector).getObject(index);
                }
            };
        }

        public Arrow2PaimonVectorConverter visit(BinaryType binaryType) {
            return vector -> new BytesColumnVector(){

                public boolean isNullAt(int index) {
                    return vector.isNull(index);
                }

                public BytesColumnVector.Bytes getBytes(int index) {
                    final byte[] bytes = ((VarBinaryVector)vector).getObject(index);
                    return new BytesColumnVector.Bytes(bytes, 0, bytes.length){

                        public byte[] getBytes() {
                            return bytes;
                        }
                    };
                }
            };
        }

        public Arrow2PaimonVectorConverter visit(VarBinaryType varBinaryType) {
            return vector -> new BytesColumnVector(){

                public boolean isNullAt(int index) {
                    return vector.isNull(index);
                }

                public BytesColumnVector.Bytes getBytes(int index) {
                    final byte[] bytes = ((VarBinaryVector)vector).getObject(index);
                    return new BytesColumnVector.Bytes(bytes, 0, bytes.length){

                        public byte[] getBytes() {
                            return bytes;
                        }
                    };
                }
            };
        }

        public Arrow2PaimonVectorConverter visit(DecimalType decimalType) {
            return vector -> new DecimalColumnVector(){

                public boolean isNullAt(int index) {
                    return vector.isNull(index);
                }

                public Decimal getDecimal(int index, int precision, int scale) {
                    return Decimal.fromBigDecimal((BigDecimal)((DecimalVector)vector).getObject(index), (int)precision, (int)scale);
                }
            };
        }

        public Arrow2PaimonVectorConverter visit(TinyIntType tinyIntType) {
            return vector -> new ByteColumnVector(){

                public boolean isNullAt(int index) {
                    return vector.isNull(index);
                }

                public byte getByte(int index) {
                    return ((TinyIntVector)vector).getObject(index);
                }
            };
        }

        public Arrow2PaimonVectorConverter visit(SmallIntType smallIntType) {
            return vector -> new ShortColumnVector(){

                public boolean isNullAt(int index) {
                    return vector.isNull(index);
                }

                public short getShort(int index) {
                    return ((SmallIntVector)vector).getObject(index);
                }
            };
        }

        public Arrow2PaimonVectorConverter visit(IntType intType) {
            return vector -> new IntColumnVector(){

                public boolean isNullAt(int index) {
                    return vector.isNull(index);
                }

                public int getInt(int index) {
                    return ((IntVector)vector).getObject(index);
                }
            };
        }

        public Arrow2PaimonVectorConverter visit(BigIntType bigIntType) {
            return vector -> new LongColumnVector(){

                public boolean isNullAt(int index) {
                    return vector.isNull(index);
                }

                public long getLong(int index) {
                    return ((BigIntVector)vector).getObject(index);
                }
            };
        }

        public Arrow2PaimonVectorConverter visit(FloatType floatType) {
            return vector -> new FloatColumnVector(){

                public boolean isNullAt(int index) {
                    return vector.isNull(index);
                }

                public float getFloat(int index) {
                    return ((Float4Vector)vector).getObject(index).floatValue();
                }
            };
        }

        public Arrow2PaimonVectorConverter visit(DoubleType doubleType) {
            return vector -> new DoubleColumnVector(){

                public boolean isNullAt(int index) {
                    return vector.isNull(index);
                }

                public double getDouble(int index) {
                    return ((Float8Vector)vector).getObject(index);
                }
            };
        }

        public Arrow2PaimonVectorConverter visit(DateType dateType) {
            return vector -> new IntColumnVector(){

                public boolean isNullAt(int index) {
                    return vector.isNull(index);
                }

                public int getInt(int index) {
                    return ((DateDayVector)vector).getObject(index);
                }
            };
        }

        public Arrow2PaimonVectorConverter visit(TimeType timeType) {
            return vector -> new IntColumnVector(){

                public boolean isNullAt(int index) {
                    return vector.isNull(index);
                }

                public int getInt(int index) {
                    return ((TimeMilliVector)vector).get(index);
                }
            };
        }

        public Arrow2PaimonVectorConverter visit(TimestampType timestampType) {
            return vector -> new TimestampColumnVector(){

                public boolean isNullAt(int index) {
                    return vector.isNull(index);
                }

                public Timestamp getTimestamp(int i, int precision) {
                    long value = ((TimeStampVector)vector).get(i);
                    if (precision == 0) {
                        return Timestamp.fromEpochMillis((long)(value * 1000L));
                    }
                    if (precision >= 1 && precision <= 3) {
                        return Timestamp.fromEpochMillis((long)value);
                    }
                    if (precision >= 4 && precision <= 6) {
                        return Timestamp.fromMicros((long)value);
                    }
                    return Timestamp.fromEpochMillis((long)(value / 1000000L), (int)((int)value % 1000000));
                }
            };
        }

        public Arrow2PaimonVectorConverter visit(LocalZonedTimestampType localZonedTimestampType) {
            return vector -> new TimestampColumnVector(){

                public boolean isNullAt(int index) {
                    return vector.isNull(index);
                }

                public Timestamp getTimestamp(int i, int precision) {
                    long value = (Long)vector.getObject(i);
                    if (precision == 0) {
                        return Timestamp.fromEpochMillis((long)(value * 1000L));
                    }
                    if (precision >= 1 && precision <= 3) {
                        return Timestamp.fromEpochMillis((long)value);
                    }
                    if (precision >= 4 && precision <= 6) {
                        return Timestamp.fromMicros((long)value);
                    }
                    return Timestamp.fromEpochMillis((long)(value / 1000000L), (int)((int)value % 1000000));
                }
            };
        }

        public Arrow2PaimonVectorConverter visit(ArrayType arrayType) {
            final Arrow2PaimonVectorConverter arrowVectorConvertor = (Arrow2PaimonVectorConverter)arrayType.getElementType().accept((DataTypeVisitor)this);
            return vector -> new ArrayColumnVector(){
                private boolean inited = false;
                private ColumnVector columnVector;

                private void init() {
                    if (!this.inited) {
                        FieldVector child = ((ListVector)vector).getDataVector();
                        this.columnVector = arrowVectorConvertor.convertVector(child);
                        this.inited = true;
                    }
                }

                public boolean isNullAt(int index) {
                    return vector.isNull(index);
                }

                public InternalArray getArray(int index) {
                    this.init();
                    ListVector listVector = (ListVector)vector;
                    int start = listVector.getElementStartIndex(index);
                    int end = listVector.getElementEndIndex(index);
                    return new ColumnarArray(this.columnVector, start, end - start);
                }

                public ColumnVector getColumnVector() {
                    this.init();
                    return this.columnVector;
                }
            };
        }

        public Arrow2PaimonVectorConverter visit(MultisetType multisetType) {
            throw new UnsupportedOperationException("Doesn't support MultisetType.");
        }

        public Arrow2PaimonVectorConverter visit(MapType mapType) {
            final Arrow2PaimonVectorConverter keyConvertor = (Arrow2PaimonVectorConverter)mapType.getKeyType().accept((DataTypeVisitor)this);
            final Arrow2PaimonVectorConverter valueConverter = (Arrow2PaimonVectorConverter)mapType.getValueType().accept((DataTypeVisitor)this);
            return vector -> new MapColumnVector(){
                private boolean inited = false;
                private ListVector mapVector;
                private ColumnVector keyColumnVector;
                private ColumnVector valueColumnVector;

                private void init() {
                    if (!this.inited) {
                        this.mapVector = (ListVector)vector;
                        StructVector listVector = (StructVector)this.mapVector.getDataVector();
                        FieldVector keyVector = (FieldVector)listVector.getChildrenFromFields().get(0);
                        FieldVector valueVector = (FieldVector)listVector.getChildrenFromFields().get(1);
                        this.keyColumnVector = keyConvertor.convertVector(keyVector);
                        this.valueColumnVector = valueConverter.convertVector(valueVector);
                        this.inited = true;
                    }
                }

                public boolean isNullAt(int index) {
                    return vector.isNull(index);
                }

                public InternalMap getMap(int index) {
                    this.init();
                    int start = this.mapVector.getElementStartIndex(index);
                    int end = this.mapVector.getElementEndIndex(index);
                    return new ColumnarMap(this.keyColumnVector, this.valueColumnVector, start, end - start);
                }

                public ColumnVector getKeyColumnVector() {
                    this.init();
                    return this.keyColumnVector;
                }

                public ColumnVector getValueColumnVector() {
                    this.init();
                    return this.valueColumnVector;
                }
            };
        }

        public Arrow2PaimonVectorConverter visit(RowType rowType) {
            final ArrayList<Object> convertors = new ArrayList<Object>();
            for (int i = 0; i < rowType.getFields().size(); ++i) {
                convertors.add(rowType.getTypeAt(i).accept((DataTypeVisitor)this));
            }
            return vector -> new RowColumnVector(){
                private boolean inited = false;
                private VectorizedColumnBatch vectorizedColumnBatch;

                private void init() {
                    if (!this.inited) {
                        List children = ((StructVector)vector).getChildrenFromFields();
                        ColumnVector[] vectors = new ColumnVector[children.size()];
                        for (int i = 0; i < children.size(); ++i) {
                            vectors[i] = ((Arrow2PaimonVectorConverter)convertors.get(i)).convertVector((FieldVector)children.get(i));
                        }
                        this.vectorizedColumnBatch = new VectorizedColumnBatch(vectors);
                        this.inited = true;
                    }
                }

                public boolean isNullAt(int index) {
                    return vector.isNull(index);
                }

                public InternalRow getRow(int index) {
                    this.init();
                    return new ColumnarRow(this.vectorizedColumnBatch, index);
                }

                public VectorizedColumnBatch getBatch() {
                    this.init();
                    return this.vectorizedColumnBatch;
                }
            };
        }
    }
}

