/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.arrow.converter;

import javax.annotation.Nullable;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.paimon.arrow.writer.ArrowFieldWriter;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.reader.RecordReader;

public abstract class ArrowBatchConverter {
    protected final VectorSchemaRoot root;
    protected final ArrowFieldWriter[] fieldWriters;
    protected RecordReader.RecordIterator<InternalRow> iterator;

    ArrowBatchConverter(VectorSchemaRoot root, ArrowFieldWriter[] fieldWriters) {
        this.root = root;
        this.fieldWriters = fieldWriters;
    }

    @Nullable
    public VectorSchemaRoot next(int maxBatchRows) {
        if (this.iterator == null) {
            return null;
        }
        for (ArrowFieldWriter fieldWriter : this.fieldWriters) {
            fieldWriter.reset();
        }
        this.doWrite(maxBatchRows);
        return this.root;
    }

    protected abstract void doWrite(int var1);

    public void close() {
        this.root.close();
    }

    protected void releaseIterator() {
        this.iterator.releaseBatch();
        this.iterator = null;
    }
}

