/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.arrow.converter;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.paimon.arrow.converter.ArrowBatchConverter;
import org.apache.paimon.arrow.writer.ArrowFieldWriter;
import org.apache.paimon.data.DataGetters;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.reader.RecordReader;

public class ArrowPerRowBatchConverter
extends ArrowBatchConverter {
    private InternalRow currentRow;

    public ArrowPerRowBatchConverter(VectorSchemaRoot root, ArrowFieldWriter[] fieldWriters) {
        super(root, fieldWriters);
    }

    @Override
    public void doWrite(int maxBatchRows) {
        int rowIndex;
        for (rowIndex = 0; this.currentRow != null && rowIndex < maxBatchRows; ++rowIndex) {
            for (int i = 0; i < this.fieldWriters.length; ++i) {
                this.fieldWriters[i].write(rowIndex, (DataGetters)this.currentRow, i);
            }
            this.nextRow();
        }
        this.root.setRowCount(rowIndex);
        if (this.currentRow == null) {
            this.releaseIterator();
        }
    }

    public void reset(RecordReader.RecordIterator<InternalRow> iterator) {
        this.iterator = iterator;
        this.nextRow();
    }

    private void nextRow() {
        try {
            this.currentRow = (InternalRow)this.iterator.next();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

