/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.arrow.converter;

import javax.annotation.Nullable;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.paimon.arrow.converter.ArrowBatchConverter;
import org.apache.paimon.arrow.writer.ArrowFieldWriter;
import org.apache.paimon.data.columnar.ColumnVector;
import org.apache.paimon.data.columnar.VectorizedColumnBatch;
import org.apache.paimon.deletionvectors.ApplyDeletionFileRecordIterator;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.reader.FileRecordIterator;
import org.apache.paimon.reader.VectorizedRecordIterator;
import org.apache.paimon.utils.IntArrayList;

public class ArrowVectorizedBatchConverter
extends ArrowBatchConverter {
    private VectorizedColumnBatch batch;
    @Nullable
    private int[] pickedInColumn;
    private int totalNumRows;
    private int startIndex;

    public ArrowVectorizedBatchConverter(VectorSchemaRoot root, ArrowFieldWriter[] fieldWriters) {
        super(root, fieldWriters);
    }

    @Override
    public void doWrite(int maxBatchRows) {
        int batchRows = Math.min(maxBatchRows, this.totalNumRows - this.startIndex);
        ColumnVector[] columns = this.batch.columns;
        for (int i = 0; i < columns.length; ++i) {
            this.fieldWriters[i].write(columns[i], this.pickedInColumn, this.startIndex, batchRows);
        }
        this.root.setRowCount(batchRows);
        this.startIndex += batchRows;
        if (this.startIndex >= this.totalNumRows) {
            this.releaseIterator();
        }
    }

    public void reset(ApplyDeletionFileRecordIterator iterator) {
        this.iterator = iterator;
        FileRecordIterator innerIterator = iterator.iterator();
        this.batch = ((VectorizedRecordIterator)innerIterator).batch();
        long firstReturnedPosition = innerIterator.returnedPosition() + 1L;
        DeletionVector deletionVector = iterator.deletionVector();
        int originNumRows = this.batch.getNumRows();
        IntArrayList picked = new IntArrayList(originNumRows);
        for (int i = 0; i < originNumRows; ++i) {
            long returnedPosition = firstReturnedPosition + (long)i;
            if (deletionVector.isDeleted(returnedPosition)) continue;
            picked.add(i);
        }
        if (picked.size() == originNumRows) {
            this.pickedInColumn = null;
            this.totalNumRows = originNumRows;
        } else {
            this.pickedInColumn = picked.toArray();
            this.totalNumRows = this.pickedInColumn.length;
        }
        this.startIndex = 0;
    }

    public void reset(VectorizedRecordIterator iterator) {
        this.iterator = iterator;
        this.batch = iterator.batch();
        this.pickedInColumn = null;
        this.totalNumRows = this.batch.getNumRows();
        this.startIndex = 0;
    }
}

