/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.arrow.reader;

import java.util.Iterator;
import java.util.List;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.paimon.arrow.converter.Arrow2PaimonVectorConverter;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.columnar.ColumnVector;
import org.apache.paimon.data.columnar.ColumnarRow;
import org.apache.paimon.data.columnar.VectorizedColumnBatch;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;

public class ArrowBatchReader {
    private final InternalRowSerializer internalRowSerializer;
    private final VectorizedColumnBatch batch;
    private final Arrow2PaimonVectorConverter[] convertors;
    private final RowType projectedRowType;

    public ArrowBatchReader(RowType rowType) {
        this.internalRowSerializer = new InternalRowSerializer(rowType);
        ColumnVector[] columnVectors = new ColumnVector[rowType.getFieldCount()];
        this.convertors = new Arrow2PaimonVectorConverter[rowType.getFieldCount()];
        this.batch = new VectorizedColumnBatch(columnVectors);
        this.projectedRowType = rowType;
        for (int i = 0; i < columnVectors.length; ++i) {
            this.convertors[i] = Arrow2PaimonVectorConverter.construct(rowType.getTypeAt(i));
        }
    }

    public Iterable<InternalRow> readBatch(VectorSchemaRoot vsr) {
        int i;
        int[] mapping = new int[this.projectedRowType.getFieldCount()];
        Schema arrowSchema = vsr.getSchema();
        List dataFields = this.projectedRowType.getFields();
        for (i = 0; i < dataFields.size(); ++i) {
            try {
                int idx;
                Field field = arrowSchema.findField(((DataField)dataFields.get(i)).name().toLowerCase());
                mapping[i] = idx = arrowSchema.getFields().indexOf(field);
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
        for (i = 0; i < this.batch.columns.length; ++i) {
            this.batch.columns[i] = this.convertors[i].convertVector(vsr.getVector(mapping[i]));
        }
        final int rowCount = vsr.getRowCount();
        this.batch.setNumRows(vsr.getRowCount());
        final ColumnarRow columnarRow = new ColumnarRow(this.batch);
        return () -> new Iterator<InternalRow>(){
            private int position = 0;

            @Override
            public boolean hasNext() {
                return this.position < rowCount;
            }

            @Override
            public InternalRow next() {
                columnarRow.setRowId(this.position);
                ++this.position;
                return this.position == rowCount ? ArrowBatchReader.this.internalRowSerializer.toBinaryRow((InternalRow)columnarRow) : columnarRow;
            }
        };
    }
}

