/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.arrow.vector;

import org.apache.arrow.c.ArrowArray;
import org.apache.arrow.c.ArrowSchema;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.paimon.arrow.ArrowUtils;
import org.apache.paimon.arrow.vector.ArrowCStruct;
import org.apache.paimon.arrow.vector.ArrowFormatWriter;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.types.RowType;

public class ArrowFormatCWriter
implements AutoCloseable {
    private final ArrowArray array;
    private final ArrowSchema schema;
    private final ArrowFormatWriter realWriter;

    public ArrowFormatCWriter(RowType rowType, int writeBatchSize, boolean allowUpperCase) {
        this.realWriter = new ArrowFormatWriter(rowType, writeBatchSize, allowUpperCase);
        RootAllocator allocator = this.realWriter.getAllocator();
        this.array = ArrowArray.allocateNew((BufferAllocator)allocator);
        this.schema = ArrowSchema.allocateNew((BufferAllocator)allocator);
    }

    public boolean write(InternalRow currentRow) {
        return this.realWriter.write(currentRow);
    }

    public ArrowCStruct flush() {
        this.realWriter.flush();
        VectorSchemaRoot vectorSchemaRoot = this.realWriter.getVectorSchemaRoot();
        return ArrowUtils.serializeToCStruct(vectorSchemaRoot, this.array, this.schema);
    }

    public boolean empty() {
        return this.realWriter.empty();
    }

    public void release() {
        this.array.release();
        this.schema.release();
    }

    @Override
    public void close() {
        this.array.close();
        this.schema.close();
        this.realWriter.close();
    }

    public VectorSchemaRoot getVectorSchemaRoot() {
        return this.realWriter.getVectorSchemaRoot();
    }

    public RootAllocator getAllocator() {
        return this.realWriter.getAllocator();
    }
}

