/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.arrow.vector;

import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.util.OversizedAllocationException;
import org.apache.paimon.arrow.ArrowUtils;
import org.apache.paimon.arrow.writer.ArrowFieldWriter;
import org.apache.paimon.arrow.writer.ArrowFieldWriterFactory;
import org.apache.paimon.arrow.writer.ArrowFieldWriterFactoryVisitor;
import org.apache.paimon.data.DataGetters;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataTypeVisitor;
import org.apache.paimon.types.RowType;

public class ArrowFormatWriter
implements AutoCloseable {
    private final VectorSchemaRoot vectorSchemaRoot;
    private final ArrowFieldWriter[] fieldWriters;
    private final int batchSize;
    private final RootAllocator allocator = new RootAllocator();
    private int rowId;

    public ArrowFormatWriter(RowType rowType, int writeBatchSize, boolean allowUpperCase) {
        this.vectorSchemaRoot = ArrowUtils.createVectorSchemaRoot(rowType, (BufferAllocator)this.allocator, allowUpperCase);
        this.fieldWriters = new ArrowFieldWriter[rowType.getFieldCount()];
        for (int i = 0; i < this.fieldWriters.length; ++i) {
            this.fieldWriters[i] = ((ArrowFieldWriterFactory)((DataField)rowType.getFields().get(i)).type().accept((DataTypeVisitor)ArrowFieldWriterFactoryVisitor.INSTANCE)).create(this.vectorSchemaRoot.getVector(i));
        }
        this.batchSize = writeBatchSize;
    }

    public void flush() {
        this.vectorSchemaRoot.setRowCount(this.rowId);
        this.rowId = 0;
    }

    public boolean write(InternalRow currentRow) {
        if (this.rowId >= this.batchSize) {
            return false;
        }
        for (int i = 0; i < currentRow.getFieldCount(); ++i) {
            try {
                this.fieldWriters[i].write(this.rowId, (DataGetters)currentRow, i);
                continue;
            }
            catch (IndexOutOfBoundsException | OversizedAllocationException e) {
                return false;
            }
        }
        ++this.rowId;
        return true;
    }

    public boolean empty() {
        return this.rowId == 0;
    }

    @Override
    public void close() {
        this.vectorSchemaRoot.close();
        this.allocator.close();
    }

    public VectorSchemaRoot getVectorSchemaRoot() {
        return this.vectorSchemaRoot;
    }

    public RootAllocator getAllocator() {
        return this.allocator;
    }
}

