/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.arrow.vector;

import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.paimon.arrow.ArrowUtils;
import org.apache.paimon.arrow.writer.ArrowFieldWriter;
import org.apache.paimon.arrow.writer.ArrowFieldWriterFactory;
import org.apache.paimon.arrow.writer.ArrowFieldWriterFactoryVisitor;
import org.apache.paimon.data.DataGetters;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataTypeVisitor;

public class OneElementFieldVectorGenerator
implements AutoCloseable {
    private final GenericRow row;
    private final FieldVector fieldVector;
    private final ArrowFieldWriter writer;
    private int pos = 0;

    public OneElementFieldVectorGenerator(BufferAllocator bufferAllocator, DataField dataField, Object value) {
        this.fieldVector = ArrowUtils.createVector(dataField, bufferAllocator, false);
        this.writer = ((ArrowFieldWriterFactory)dataField.type().accept((DataTypeVisitor)ArrowFieldWriterFactoryVisitor.INSTANCE)).create(this.fieldVector);
        this.row = new GenericRow(1);
        this.row.setField(0, value);
    }

    public FieldVector get(int rowCount) {
        if (rowCount > this.pos) {
            for (int i = this.pos; i < rowCount; ++i) {
                this.writer.write(i, (DataGetters)this.row, 0);
            }
            this.pos = rowCount;
        }
        this.fieldVector.setValueCount(rowCount);
        return this.fieldVector;
    }

    @Override
    public void close() {
        this.fieldVector.close();
    }
}

