/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.arrow.writer;

import javax.annotation.Nullable;
import org.apache.arrow.vector.FieldVector;
import org.apache.paimon.data.DataGetters;
import org.apache.paimon.data.columnar.ColumnVector;

public abstract class ArrowFieldWriter {
    protected final FieldVector fieldVector;

    public ArrowFieldWriter(FieldVector fieldVector) {
        this.fieldVector = fieldVector;
    }

    public void reset() {
        this.fieldVector.reset();
    }

    public void write(ColumnVector columnVector, @Nullable int[] pickedInColumn, int startIndex, int batchRows) {
        this.doWrite(columnVector, pickedInColumn, startIndex, batchRows);
        this.fieldVector.setValueCount(batchRows);
    }

    protected abstract void doWrite(ColumnVector var1, @Nullable int[] var2, int var3, int var4);

    public void write(int rowIndex, DataGetters getters, int pos) {
        if (getters.isNullAt(pos)) {
            this.fieldVector.setNull(rowIndex);
        } else {
            this.doWrite(rowIndex, getters, pos);
        }
    }

    protected abstract void doWrite(int var1, DataGetters var2, int var3);

    protected int getRowNumber(int startIndex, int currentIndex, @Nullable int[] pickedInColumn) {
        int row = currentIndex + startIndex;
        if (pickedInColumn != null) {
            row = pickedInColumn[row];
        }
        return row;
    }
}

