/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.arrow.writer;

import java.util.List;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.paimon.arrow.writer.ArrowFieldWriter;
import org.apache.paimon.arrow.writer.ArrowFieldWriterFactory;
import org.apache.paimon.arrow.writer.ArrowFieldWriters;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.BinaryType;
import org.apache.paimon.types.BooleanType;
import org.apache.paimon.types.CharType;
import org.apache.paimon.types.DataTypeVisitor;
import org.apache.paimon.types.DateType;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.DoubleType;
import org.apache.paimon.types.FloatType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.SmallIntType;
import org.apache.paimon.types.TimeType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.types.TinyIntType;
import org.apache.paimon.types.VarBinaryType;
import org.apache.paimon.types.VarCharType;

public class ArrowFieldWriterFactoryVisitor
implements DataTypeVisitor<ArrowFieldWriterFactory> {
    public static final ArrowFieldWriterFactoryVisitor INSTANCE = new ArrowFieldWriterFactoryVisitor();

    public ArrowFieldWriterFactory visit(CharType charType) {
        return ArrowFieldWriters.StringWriter::new;
    }

    public ArrowFieldWriterFactory visit(VarCharType varCharType) {
        return ArrowFieldWriters.StringWriter::new;
    }

    public ArrowFieldWriterFactory visit(BooleanType booleanType) {
        return ArrowFieldWriters.BooleanWriter::new;
    }

    public ArrowFieldWriterFactory visit(BinaryType binaryType) {
        return ArrowFieldWriters.BinaryWriter::new;
    }

    public ArrowFieldWriterFactory visit(VarBinaryType varBinaryType) {
        return ArrowFieldWriters.BinaryWriter::new;
    }

    public ArrowFieldWriterFactory visit(DecimalType decimalType) {
        return fieldVector -> new ArrowFieldWriters.DecimalWriter(fieldVector, decimalType.getPrecision(), decimalType.getScale());
    }

    public ArrowFieldWriterFactory visit(TinyIntType tinyIntType) {
        return ArrowFieldWriters.TinyIntWriter::new;
    }

    public ArrowFieldWriterFactory visit(SmallIntType smallIntType) {
        return ArrowFieldWriters.SmallIntWriter::new;
    }

    public ArrowFieldWriterFactory visit(IntType intType) {
        return ArrowFieldWriters.IntWriter::new;
    }

    public ArrowFieldWriterFactory visit(BigIntType bigIntType) {
        return ArrowFieldWriters.BigIntWriter::new;
    }

    public ArrowFieldWriterFactory visit(FloatType floatType) {
        return ArrowFieldWriters.FloatWriter::new;
    }

    public ArrowFieldWriterFactory visit(DoubleType doubleType) {
        return ArrowFieldWriters.DoubleWriter::new;
    }

    public ArrowFieldWriterFactory visit(DateType dateType) {
        return ArrowFieldWriters.DateWriter::new;
    }

    public ArrowFieldWriterFactory visit(TimeType timeType) {
        return ArrowFieldWriters.TimeWriter::new;
    }

    public ArrowFieldWriterFactory visit(TimestampType timestampType) {
        return fieldVector -> new ArrowFieldWriters.TimestampWriter(fieldVector, timestampType.getPrecision(), null);
    }

    public ArrowFieldWriterFactory visit(LocalZonedTimestampType localZonedTimestampType) {
        return fieldVector -> new ArrowFieldWriters.TimestampWriter(fieldVector, localZonedTimestampType.getPrecision(), null);
    }

    public ArrowFieldWriterFactory visit(ArrayType arrayType) {
        ArrowFieldWriterFactory elementWriterFactory = (ArrowFieldWriterFactory)arrayType.getElementType().accept((DataTypeVisitor)this);
        return fieldVector -> new ArrowFieldWriters.ArrayWriter(fieldVector, elementWriterFactory.create(((ListVector)fieldVector).getDataVector()));
    }

    public ArrowFieldWriterFactory visit(MultisetType multisetType) {
        throw new UnsupportedOperationException("Doesn't support MultisetType.");
    }

    public ArrowFieldWriterFactory visit(MapType mapType) {
        ArrowFieldWriterFactory keyWriterFactory = (ArrowFieldWriterFactory)mapType.getKeyType().accept((DataTypeVisitor)this);
        ArrowFieldWriterFactory valueWriterFactory = (ArrowFieldWriterFactory)mapType.getValueType().accept((DataTypeVisitor)this);
        return fieldVector -> {
            MapVector mapVector = (MapVector)fieldVector;
            List keyValueVectors = mapVector.getDataVector().getChildrenFromFields();
            return new ArrowFieldWriters.MapWriter(fieldVector, keyWriterFactory.create((FieldVector)keyValueVectors.get(0)), valueWriterFactory.create((FieldVector)keyValueVectors.get(1)));
        };
    }

    public ArrowFieldWriterFactory visit(RowType rowType) {
        return fieldVector -> {
            List children = fieldVector.getChildrenFromFields();
            ArrowFieldWriter[] fieldWriters = new ArrowFieldWriter[children.size()];
            for (int i = 0; i < children.size(); ++i) {
                fieldWriters[i] = ((ArrowFieldWriterFactory)rowType.getTypeAt(i).accept((DataTypeVisitor)this)).create((FieldVector)children.get(i));
            }
            return new ArrowFieldWriters.RowWriter(fieldVector, fieldWriters);
        };
    }
}

