/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.arrow.writer;

import java.math.BigDecimal;
import java.time.ZoneId;
import javax.annotation.Nullable;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeStampVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.paimon.arrow.ArrowUtils;
import org.apache.paimon.arrow.writer.ArrowFieldWriter;
import org.apache.paimon.data.DataGetters;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.data.columnar.ArrayColumnVector;
import org.apache.paimon.data.columnar.BooleanColumnVector;
import org.apache.paimon.data.columnar.ByteColumnVector;
import org.apache.paimon.data.columnar.BytesColumnVector;
import org.apache.paimon.data.columnar.ColumnVector;
import org.apache.paimon.data.columnar.DecimalColumnVector;
import org.apache.paimon.data.columnar.DoubleColumnVector;
import org.apache.paimon.data.columnar.FloatColumnVector;
import org.apache.paimon.data.columnar.IntColumnVector;
import org.apache.paimon.data.columnar.LongColumnVector;
import org.apache.paimon.data.columnar.MapColumnVector;
import org.apache.paimon.data.columnar.RowColumnVector;
import org.apache.paimon.data.columnar.ShortColumnVector;
import org.apache.paimon.data.columnar.TimestampColumnVector;
import org.apache.paimon.data.columnar.VectorizedColumnBatch;
import org.apache.paimon.utils.IntArrayList;

public class ArrowFieldWriters {
    private static ArrayChildWriteInfo getArrayChildWriteInfo(@Nullable int[] pickedInParentColumn, int parentStartIndex, int[] parentLengths) {
        return pickedInParentColumn == null ? ArrowFieldWriters.getArrayChildWriteInfoWithoutDelete(parentStartIndex, parentLengths) : ArrowFieldWriters.getArrayChildWriteInfoWithDelete(pickedInParentColumn, parentStartIndex, parentLengths);
    }

    private static ArrayChildWriteInfo getArrayChildWriteInfoWithoutDelete(int parentStartIndex, int[] parentLengths) {
        int firstElementIndex = 0;
        int childBatchRows = 0;
        for (int i = 0; i < parentLengths.length; ++i) {
            if (i < parentStartIndex) {
                firstElementIndex += parentLengths[i];
                continue;
            }
            childBatchRows += parentLengths[i];
        }
        return new ArrayChildWriteInfo(null, firstElementIndex, childBatchRows);
    }

    private static ArrayChildWriteInfo getArrayChildWriteInfoWithDelete(int[] pickedInParentColumn, int parentStartIndex, int[] parentLengths) {
        int firstElementIndex = 0;
        IntArrayList childPicked = new IntArrayList(1024);
        int offset = 0;
        int currentParentPickedIndex = parentStartIndex;
        for (int i = 0; i < parentLengths.length; ++i) {
            if (i < pickedInParentColumn[parentStartIndex]) {
                offset = firstElementIndex += parentLengths[i];
                continue;
            }
            if (i == pickedInParentColumn[currentParentPickedIndex]) {
                for (int pick = 0; pick < parentLengths[i]; ++pick) {
                    childPicked.add(pick + offset);
                }
                ++currentParentPickedIndex;
            }
            offset += parentLengths[i];
        }
        return new ArrayChildWriteInfo(childPicked.toArray(), 0, childPicked.size());
    }

    public static class RowWriter
    extends ArrowFieldWriter {
        private final ArrowFieldWriter[] fieldWriters;

        public RowWriter(FieldVector fieldVector, ArrowFieldWriter[] fieldWriters) {
            super(fieldVector);
            this.fieldWriters = fieldWriters;
        }

        @Override
        protected void doWrite(ColumnVector columnVector, @Nullable int[] pickedInColumn, int startIndex, int batchRows) {
            boolean[] isNull = new boolean[batchRows];
            boolean allNull = true;
            for (int i = 0; i < batchRows; ++i) {
                int row = this.getRowNumber(startIndex, i, pickedInColumn);
                if (columnVector.isNullAt(row)) {
                    isNull[i] = true;
                    continue;
                }
                allNull = false;
            }
            RowColumnVector rowColumnVector = (RowColumnVector)columnVector;
            VectorizedColumnBatch batch = rowColumnVector.getBatch();
            int nestedBatchRows = allNull ? 0 : batchRows;
            for (int i = 0; i < this.fieldWriters.length; ++i) {
                this.fieldWriters[i].write(batch.columns[i], pickedInColumn, startIndex, nestedBatchRows);
            }
            StructVector structVector = (StructVector)this.fieldVector;
            for (int i = 0; i < batchRows; ++i) {
                if (isNull[i]) {
                    structVector.setNull(i);
                    continue;
                }
                structVector.setIndexDefined(i);
            }
        }

        @Override
        protected void doWrite(int rowIndex, DataGetters getters, int pos) {
            int fieldCount = this.fieldWriters.length;
            InternalRow row = getters.getRow(pos, fieldCount);
            StructVector structVector = (StructVector)this.fieldVector;
            for (int i = 0; i < this.fieldWriters.length; ++i) {
                this.fieldWriters[i].write(rowIndex, (DataGetters)row, i);
            }
            structVector.setIndexDefined(rowIndex);
        }
    }

    private static class ArrayChildWriteInfo {
        @Nullable
        final int[] pickedInColumn;
        final int startIndex;
        final int batchRows;

        ArrayChildWriteInfo(@Nullable int[] pickedInColumn, int startIndex, int batchRows) {
            this.pickedInColumn = pickedInColumn;
            this.startIndex = startIndex;
            this.batchRows = batchRows;
        }
    }

    public static class MapWriter
    extends ArrowFieldWriter {
        private final ArrowFieldWriter keyWriter;
        private final ArrowFieldWriter valueWriter;
        private int offset;

        public MapWriter(FieldVector fieldVector, ArrowFieldWriter keyWriter, ArrowFieldWriter valueWriter) {
            super(fieldVector);
            this.keyWriter = keyWriter;
            this.valueWriter = valueWriter;
        }

        @Override
        public void reset() {
            this.fieldVector.reset();
            this.offset = 0;
        }

        @Override
        protected void doWrite(ColumnVector columnVector, @Nullable int[] pickedInColumn, int startIndex, int batchRows) {
            MapColumnVector mapColumnVector = (MapColumnVector)columnVector;
            int lenSize = pickedInColumn == null ? startIndex + batchRows : pickedInColumn[startIndex + batchRows - 1] + 1;
            int[] lengths = new int[lenSize];
            for (int i = 0; i < lenSize; ++i) {
                int size;
                lengths[i] = mapColumnVector.isNullAt(i) ? 0 : (size = mapColumnVector.getMap(i).size());
            }
            ArrayChildWriteInfo arrayChildWriteInfo = ArrowFieldWriters.getArrayChildWriteInfo(pickedInColumn, startIndex, lengths);
            this.keyWriter.write(mapColumnVector.getKeyColumnVector(), arrayChildWriteInfo.pickedInColumn, arrayChildWriteInfo.startIndex, arrayChildWriteInfo.batchRows);
            this.valueWriter.write(mapColumnVector.getValueColumnVector(), arrayChildWriteInfo.pickedInColumn, arrayChildWriteInfo.startIndex, arrayChildWriteInfo.batchRows);
            MapVector mapVector = (MapVector)this.fieldVector;
            StructVector innerStructVector = (StructVector)mapVector.getDataVector();
            for (int i = 0; i < arrayChildWriteInfo.batchRows; ++i) {
                innerStructVector.setIndexDefined(i);
            }
            ListVector listVector = (ListVector)this.fieldVector;
            for (int i = 0; i < batchRows; ++i) {
                int row = this.getRowNumber(startIndex, i, pickedInColumn);
                if (mapColumnVector.isNullAt(row)) {
                    listVector.setNull(i);
                    continue;
                }
                listVector.startNewValue(i);
                listVector.endValue(i, lengths[row]);
            }
        }

        @Override
        protected void doWrite(int rowIndex, DataGetters getters, int pos) {
            InternalMap map = getters.getMap(pos);
            InternalArray keyArray = map.keyArray();
            InternalArray valueArray = map.valueArray();
            MapVector mapVector = (MapVector)this.fieldVector;
            StructVector structVector = (StructVector)mapVector.getDataVector();
            mapVector.startNewValue(rowIndex);
            for (int mapIndex = 0; mapIndex < map.size(); ++mapIndex) {
                int fieldIndex = this.offset + mapIndex;
                this.keyWriter.write(fieldIndex, (DataGetters)keyArray, mapIndex);
                this.valueWriter.write(fieldIndex, (DataGetters)valueArray, mapIndex);
                structVector.setIndexDefined(fieldIndex);
            }
            this.offset += map.size();
            mapVector.endValue(rowIndex, map.size());
        }
    }

    public static class ArrayWriter
    extends ArrowFieldWriter {
        private final ArrowFieldWriter elementWriter;
        private int offset;

        public ArrayWriter(FieldVector fieldVector, ArrowFieldWriter elementWriter) {
            super(fieldVector);
            this.elementWriter = elementWriter;
        }

        @Override
        public void reset() {
            this.fieldVector.reset();
            this.offset = 0;
        }

        @Override
        protected void doWrite(ColumnVector columnVector, @Nullable int[] pickedInColumn, int startIndex, int batchRows) {
            ArrayColumnVector arrayColumnVector = (ArrayColumnVector)columnVector;
            int lenSize = pickedInColumn == null ? startIndex + batchRows : pickedInColumn[startIndex + batchRows - 1] + 1;
            int[] lengths = new int[lenSize];
            for (int i = 0; i < lenSize; ++i) {
                int size;
                lengths[i] = arrayColumnVector.isNullAt(i) ? 0 : (size = arrayColumnVector.getArray(i).size());
            }
            ArrayChildWriteInfo arrayChildWriteInfo = ArrowFieldWriters.getArrayChildWriteInfo(pickedInColumn, startIndex, lengths);
            this.elementWriter.write(arrayColumnVector.getColumnVector(), arrayChildWriteInfo.pickedInColumn, arrayChildWriteInfo.startIndex, arrayChildWriteInfo.batchRows);
            ListVector listVector = (ListVector)this.fieldVector;
            for (int i = 0; i < batchRows; ++i) {
                int row = this.getRowNumber(startIndex, i, pickedInColumn);
                if (arrayColumnVector.isNullAt(row)) {
                    listVector.setNull(i);
                    continue;
                }
                listVector.startNewValue(i);
                listVector.endValue(i, lengths[row]);
            }
        }

        @Override
        protected void doWrite(int rowIndex, DataGetters getters, int pos) {
            InternalArray array = getters.getArray(pos);
            ListVector listVector = (ListVector)this.fieldVector;
            listVector.startNewValue(rowIndex);
            for (int arrIndex = 0; arrIndex < array.size(); ++arrIndex) {
                int fieldIndex = this.offset + arrIndex;
                this.elementWriter.write(fieldIndex, (DataGetters)array, arrIndex);
            }
            this.offset += array.size();
            listVector.endValue(rowIndex, array.size());
        }
    }

    public static class TimestampWriter
    extends ArrowFieldWriter {
        private final int precision;
        @Nullable
        private final ZoneId castZoneId;

        public TimestampWriter(FieldVector fieldVector, int precision, @Nullable ZoneId castZoneId) {
            super(fieldVector);
            this.precision = precision;
            this.castZoneId = castZoneId;
        }

        @Override
        protected void doWrite(ColumnVector columnVector, @Nullable int[] pickedInColumn, int startIndex, int batchRows) {
            TimeStampVector timeStampVector = (TimeStampVector)this.fieldVector;
            for (int i = 0; i < batchRows; ++i) {
                int row = this.getRowNumber(startIndex, i, pickedInColumn);
                if (columnVector.isNullAt(row)) {
                    timeStampVector.setNull(i);
                    continue;
                }
                Timestamp timestamp = ((TimestampColumnVector)columnVector).getTimestamp(row, this.precision);
                long value = ArrowUtils.timestampToEpoch(timestamp, this.precision, this.castZoneId);
                timeStampVector.setSafe(i, value);
            }
        }

        @Override
        protected void doWrite(int rowIndex, DataGetters getters, int pos) {
            TimeStampVector timeStampNanoVector = (TimeStampVector)this.fieldVector;
            Timestamp timestamp = getters.getTimestamp(pos, this.precision);
            long value = ArrowUtils.timestampToEpoch(timestamp, this.precision, this.castZoneId);
            timeStampNanoVector.setSafe(rowIndex, value);
        }
    }

    public static class TimeWriter
    extends ArrowFieldWriter {
        public TimeWriter(FieldVector fieldVector) {
            super(fieldVector);
        }

        @Override
        protected void doWrite(ColumnVector columnVector, @Nullable int[] pickedInColumn, int startIndex, int batchRows) {
            TimeMilliVector timeMilliVector = (TimeMilliVector)this.fieldVector;
            for (int i = 0; i < batchRows; ++i) {
                int row = this.getRowNumber(startIndex, i, pickedInColumn);
                if (columnVector.isNullAt(row)) {
                    timeMilliVector.setNull(i);
                    continue;
                }
                int value = ((IntColumnVector)columnVector).getInt(i);
                timeMilliVector.setSafe(i, value);
            }
        }

        @Override
        protected void doWrite(int rowIndex, DataGetters getters, int pos) {
            ((TimeMilliVector)this.fieldVector).setSafe(rowIndex, getters.getInt(pos));
        }
    }

    public static class DateWriter
    extends ArrowFieldWriter {
        public DateWriter(FieldVector fieldVector) {
            super(fieldVector);
        }

        @Override
        protected void doWrite(ColumnVector columnVector, @Nullable int[] pickedInColumn, int startIndex, int batchRows) {
            DateDayVector dateDayVector = (DateDayVector)this.fieldVector;
            for (int i = 0; i < batchRows; ++i) {
                int row = this.getRowNumber(startIndex, i, pickedInColumn);
                if (columnVector.isNullAt(row)) {
                    dateDayVector.setNull(i);
                    continue;
                }
                int value = ((IntColumnVector)columnVector).getInt(row);
                dateDayVector.setSafe(i, value);
            }
        }

        @Override
        protected void doWrite(int rowIndex, DataGetters getters, int pos) {
            ((DateDayVector)this.fieldVector).setSafe(rowIndex, getters.getInt(pos));
        }
    }

    public static class DoubleWriter
    extends ArrowFieldWriter {
        public DoubleWriter(FieldVector fieldVector) {
            super(fieldVector);
        }

        @Override
        protected void doWrite(ColumnVector columnVector, @Nullable int[] pickedInColumn, int startIndex, int batchRows) {
            Float8Vector float8Vector = (Float8Vector)this.fieldVector;
            for (int i = 0; i < batchRows; ++i) {
                int row = this.getRowNumber(startIndex, i, pickedInColumn);
                if (columnVector.isNullAt(row)) {
                    float8Vector.setNull(i);
                    continue;
                }
                double value = ((DoubleColumnVector)columnVector).getDouble(row);
                float8Vector.setSafe(i, value);
            }
        }

        @Override
        protected void doWrite(int rowIndex, DataGetters getters, int pos) {
            ((Float8Vector)this.fieldVector).setSafe(rowIndex, getters.getDouble(pos));
        }
    }

    public static class FloatWriter
    extends ArrowFieldWriter {
        public FloatWriter(FieldVector fieldVector) {
            super(fieldVector);
        }

        @Override
        protected void doWrite(ColumnVector columnVector, @Nullable int[] pickedInColumn, int startIndex, int batchRows) {
            Float4Vector float4Vector = (Float4Vector)this.fieldVector;
            for (int i = 0; i < batchRows; ++i) {
                int row = this.getRowNumber(startIndex, i, pickedInColumn);
                if (columnVector.isNullAt(row)) {
                    float4Vector.setNull(i);
                    continue;
                }
                float value = ((FloatColumnVector)columnVector).getFloat(row);
                float4Vector.setSafe(i, value);
            }
        }

        @Override
        protected void doWrite(int rowIndex, DataGetters getters, int pos) {
            ((Float4Vector)this.fieldVector).setSafe(rowIndex, getters.getFloat(pos));
        }
    }

    public static class BigIntWriter
    extends ArrowFieldWriter {
        public BigIntWriter(FieldVector fieldVector) {
            super(fieldVector);
        }

        @Override
        protected void doWrite(ColumnVector columnVector, int[] pickedInColumn, int startIndex, int batchRows) {
            BigIntVector bigIntVector = (BigIntVector)this.fieldVector;
            for (int i = 0; i < batchRows; ++i) {
                int row = this.getRowNumber(startIndex, i, pickedInColumn);
                if (columnVector.isNullAt(row)) {
                    bigIntVector.setNull(i);
                    continue;
                }
                long value = ((LongColumnVector)columnVector).getLong(row);
                bigIntVector.setSafe(i, value);
            }
        }

        @Override
        protected void doWrite(int rowIndex, DataGetters getters, int pos) {
            ((BigIntVector)this.fieldVector).setSafe(rowIndex, getters.getLong(pos));
        }
    }

    public static class IntWriter
    extends ArrowFieldWriter {
        public IntWriter(FieldVector fieldVector) {
            super(fieldVector);
        }

        @Override
        protected void doWrite(ColumnVector columnVector, @Nullable int[] pickedInColumn, int startIndex, int batchRows) {
            IntVector intVector = (IntVector)this.fieldVector;
            for (int i = 0; i < batchRows; ++i) {
                int row = this.getRowNumber(startIndex, i, pickedInColumn);
                if (columnVector.isNullAt(row)) {
                    intVector.setNull(i);
                    continue;
                }
                int value = ((IntColumnVector)columnVector).getInt(row);
                intVector.setSafe(i, value);
            }
        }

        @Override
        protected void doWrite(int rowIndex, DataGetters getters, int pos) {
            ((IntVector)this.fieldVector).setSafe(rowIndex, getters.getInt(pos));
        }
    }

    public static class SmallIntWriter
    extends ArrowFieldWriter {
        public SmallIntWriter(FieldVector fieldVector) {
            super(fieldVector);
        }

        @Override
        protected void doWrite(ColumnVector columnVector, @Nullable int[] pickedInColumn, int startIndex, int batchRows) {
            SmallIntVector smallIntVector = (SmallIntVector)this.fieldVector;
            for (int i = 0; i < batchRows; ++i) {
                int row = this.getRowNumber(startIndex, i, pickedInColumn);
                if (columnVector.isNullAt(row)) {
                    smallIntVector.setNull(i);
                    continue;
                }
                short value = ((ShortColumnVector)columnVector).getShort(row);
                smallIntVector.setSafe(i, value);
            }
        }

        @Override
        protected void doWrite(int rowIndex, DataGetters getters, int pos) {
            ((SmallIntVector)this.fieldVector).setSafe(rowIndex, getters.getShort(pos));
        }
    }

    public static class TinyIntWriter
    extends ArrowFieldWriter {
        public TinyIntWriter(FieldVector fieldVector) {
            super(fieldVector);
        }

        @Override
        protected void doWrite(ColumnVector columnVector, @Nullable int[] pickedInColumn, int startIndex, int batchRows) {
            TinyIntVector tinyIntVector = (TinyIntVector)this.fieldVector;
            for (int i = 0; i < batchRows; ++i) {
                int row = this.getRowNumber(startIndex, i, pickedInColumn);
                if (columnVector.isNullAt(row)) {
                    tinyIntVector.setNull(i);
                    continue;
                }
                byte value = ((ByteColumnVector)columnVector).getByte(row);
                tinyIntVector.setSafe(i, value);
            }
        }

        @Override
        protected void doWrite(int rowIndex, DataGetters getters, int pos) {
            ((TinyIntVector)this.fieldVector).setSafe(rowIndex, getters.getByte(pos));
        }
    }

    public static class DecimalWriter
    extends ArrowFieldWriter {
        private final int precision;
        private final int scale;

        public DecimalWriter(FieldVector fieldVector, int precision, int scale) {
            super(fieldVector);
            this.precision = precision;
            this.scale = scale;
        }

        @Override
        protected void doWrite(ColumnVector columnVector, @Nullable int[] pickedInColumn, int startIndex, int batchRows) {
            DecimalVector decimalVector = (DecimalVector)this.fieldVector;
            for (int i = 0; i < batchRows; ++i) {
                int row = this.getRowNumber(startIndex, i, pickedInColumn);
                if (columnVector.isNullAt(row)) {
                    decimalVector.setNull(i);
                    continue;
                }
                BigDecimal value = ((DecimalColumnVector)columnVector).getDecimal(row, this.precision, this.scale).toBigDecimal();
                decimalVector.setSafe(i, value);
            }
        }

        @Override
        protected void doWrite(int rowIndex, DataGetters getters, int pos) {
            ((DecimalVector)this.fieldVector).setSafe(rowIndex, getters.getDecimal(pos, this.precision, this.scale).toBigDecimal());
        }
    }

    public static class BinaryWriter
    extends ArrowFieldWriter {
        public BinaryWriter(FieldVector fieldVector) {
            super(fieldVector);
        }

        @Override
        protected void doWrite(ColumnVector columnVector, @Nullable int[] pickedInColumn, int startIndex, int batchRows) {
            VarBinaryVector varBinaryVector = (VarBinaryVector)this.fieldVector;
            for (int i = 0; i < batchRows; ++i) {
                int row = this.getRowNumber(startIndex, i, pickedInColumn);
                if (columnVector.isNullAt(row)) {
                    varBinaryVector.setNull(i);
                    continue;
                }
                byte[] value = ((BytesColumnVector)columnVector).getBytes(row).getBytes();
                varBinaryVector.setSafe(i, value);
            }
        }

        @Override
        protected void doWrite(int rowIndex, DataGetters getters, int pos) {
            ((VarBinaryVector)this.fieldVector).setSafe(rowIndex, getters.getBinary(pos));
        }
    }

    public static class BooleanWriter
    extends ArrowFieldWriter {
        public BooleanWriter(FieldVector fieldVector) {
            super(fieldVector);
        }

        @Override
        protected void doWrite(ColumnVector columnVector, @Nullable int[] pickedInColumn, int startIndex, int batchRows) {
            BitVector bitVector = (BitVector)this.fieldVector;
            for (int i = 0; i < batchRows; ++i) {
                int row = this.getRowNumber(startIndex, i, pickedInColumn);
                if (columnVector.isNullAt(row)) {
                    bitVector.setNull(row);
                    continue;
                }
                int value = ((BooleanColumnVector)columnVector).getBoolean(row) ? 1 : 0;
                bitVector.setSafe(i, value);
            }
        }

        @Override
        protected void doWrite(int rowIndex, DataGetters getters, int pos) {
            ((BitVector)this.fieldVector).setSafe(rowIndex, getters.getBoolean(pos) ? 1 : 0);
        }
    }

    public static class StringWriter
    extends ArrowFieldWriter {
        public StringWriter(FieldVector fieldVector) {
            super(fieldVector);
        }

        @Override
        protected void doWrite(ColumnVector columnVector, @Nullable int[] pickedInColumn, int startIndex, int batchRows) {
            VarCharVector varCharVector = (VarCharVector)this.fieldVector;
            for (int i = 0; i < batchRows; ++i) {
                int row = this.getRowNumber(startIndex, i, pickedInColumn);
                if (columnVector.isNullAt(row)) {
                    varCharVector.setNull(row);
                    continue;
                }
                byte[] value = ((BytesColumnVector)columnVector).getBytes(row).getBytes();
                varCharVector.setSafe(i, value);
            }
        }

        @Override
        protected void doWrite(int rowIndex, DataGetters getters, int pos) {
            ((VarCharVector)this.fieldVector).setSafe(rowIndex, getters.getString(pos).toBytes());
        }
    }
}

