/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon;

import java.time.Duration;
import java.util.Comparator;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.FileStore;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.manifest.ManifestFile;
import org.apache.paimon.manifest.ManifestList;
import org.apache.paimon.operation.FileStoreCommitImpl;
import org.apache.paimon.operation.FileStoreExpireImpl;
import org.apache.paimon.operation.PartitionExpire;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.SegmentsCache;
import org.apache.paimon.utils.SnapshotManager;

public abstract class AbstractFileStore<T>
implements FileStore<T> {
    protected final FileIO fileIO;
    protected final SchemaManager schemaManager;
    protected final long schemaId;
    protected final CoreOptions options;
    protected final RowType partitionType;
    @Nullable
    private final SegmentsCache<String> writeManifestCache;

    public AbstractFileStore(FileIO fileIO, SchemaManager schemaManager, long schemaId, CoreOptions options, RowType partitionType) {
        this.fileIO = fileIO;
        this.schemaManager = schemaManager;
        this.schemaId = schemaId;
        this.options = options;
        this.partitionType = partitionType;
        MemorySize writeManifestCache = options.writeManifestCache();
        this.writeManifestCache = writeManifestCache.getBytes() == 0L ? null : new SegmentsCache(options.pageSize(), writeManifestCache);
    }

    public FileStorePathFactory pathFactory() {
        return new FileStorePathFactory(this.options.path(), this.partitionType, this.options.partitionDefaultName(), this.options.fileFormat().getFormatIdentifier());
    }

    @Override
    public SnapshotManager snapshotManager() {
        return new SnapshotManager(this.fileIO, this.options.path());
    }

    @VisibleForTesting
    public ManifestFile.Factory manifestFileFactory() {
        return this.manifestFileFactory(false);
    }

    protected ManifestFile.Factory manifestFileFactory(boolean forWrite) {
        return new ManifestFile.Factory(this.fileIO, this.schemaManager, this.partitionType, this.options.manifestFormat(), this.pathFactory(), this.options.manifestTargetSize().getBytes(), forWrite ? this.writeManifestCache : null);
    }

    @VisibleForTesting
    public ManifestList.Factory manifestListFactory() {
        return this.manifestListFactory(false);
    }

    protected ManifestList.Factory manifestListFactory(boolean forWrite) {
        return new ManifestList.Factory(this.fileIO, this.options.manifestFormat(), this.pathFactory(), forWrite ? this.writeManifestCache : null);
    }

    @Override
    public RowType partitionType() {
        return this.partitionType;
    }

    @Override
    public CoreOptions options() {
        return this.options;
    }

    @Override
    public FileStoreCommitImpl newCommit(String commitUser) {
        return new FileStoreCommitImpl(this.fileIO, this.schemaManager, commitUser, this.partitionType, this.pathFactory(), this.snapshotManager(), this.manifestFileFactory(), this.manifestListFactory(), this.newScan(), this.options.bucket(), this.options.manifestTargetSize(), this.options.manifestMergeMinCount(), this.partitionType.getFieldCount() > 0 && this.options.dynamicPartitionOverwrite(), this.newKeyComparator());
    }

    @Override
    public FileStoreExpireImpl newExpire() {
        return new FileStoreExpireImpl(this.fileIO, this.options.snapshotNumRetainMin(), this.options.snapshotNumRetainMax(), this.options.snapshotTimeRetain().toMillis(), this.pathFactory(), this.snapshotManager(), this.manifestFileFactory(), this.manifestListFactory());
    }

    public abstract Comparator<InternalRow> newKeyComparator();

    @Override
    public PartitionExpire newPartitionExpire(String commitUser) {
        Duration partitionExpireTime = this.options.partitionExpireTime();
        if (partitionExpireTime == null || this.partitionType().getFieldCount() == 0) {
            return null;
        }
        return new PartitionExpire(this.partitionType(), partitionExpireTime, this.options.partitionExpireCheckInterval(), this.options.partitionTimestampPattern(), this.options.partitionTimestampFormatter(), this.newScan(), this.newCommit(commitUser));
    }
}

