/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon;

import java.util.Comparator;
import org.apache.paimon.AbstractFileStore;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FileFormatDiscover;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.manifest.ManifestCacheFilter;
import org.apache.paimon.operation.AppendOnlyFileStoreRead;
import org.apache.paimon.operation.AppendOnlyFileStoreScan;
import org.apache.paimon.operation.AppendOnlyFileStoreWrite;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.types.RowType;

public class AppendOnlyFileStore
extends AbstractFileStore<InternalRow> {
    private final RowType bucketKeyType;
    private final RowType rowType;

    public AppendOnlyFileStore(FileIO fileIO, SchemaManager schemaManager, long schemaId, CoreOptions options, RowType partitionType, RowType bucketKeyType, RowType rowType) {
        super(fileIO, schemaManager, schemaId, options, partitionType);
        this.bucketKeyType = bucketKeyType;
        this.rowType = rowType;
    }

    @Override
    public AppendOnlyFileStoreScan newScan() {
        return this.newScan(false);
    }

    public AppendOnlyFileStoreRead newRead() {
        return new AppendOnlyFileStoreRead(this.fileIO, this.schemaManager, this.schemaId, this.rowType, FileFormatDiscover.of(this.options), this.pathFactory());
    }

    public AppendOnlyFileStoreWrite newWrite(String commitUser) {
        return this.newWrite(commitUser, null);
    }

    public AppendOnlyFileStoreWrite newWrite(String commitUser, ManifestCacheFilter manifestFilter) {
        return new AppendOnlyFileStoreWrite(this.fileIO, this.newRead(), this.schemaId, commitUser, this.rowType, this.pathFactory(), this.snapshotManager(), this.newScan(true).withManifestCacheFilter(manifestFilter), this.options);
    }

    private AppendOnlyFileStoreScan newScan(boolean forWrite) {
        return new AppendOnlyFileStoreScan(this.partitionType, this.bucketKeyType.getFieldCount() == 0 ? this.rowType : this.bucketKeyType, this.rowType, this.snapshotManager(), this.schemaManager, this.schemaId, this.manifestFileFactory(forWrite), this.manifestListFactory(forWrite), this.options.bucket(), forWrite);
    }

    @Override
    public Comparator<InternalRow> newKeyComparator() {
        return null;
    }
}

