/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.paimon.WriteMode;
import org.apache.paimon.annotation.Documentation;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.format.FileFormat;
import org.apache.paimon.format.FileFormatFactory;
import org.apache.paimon.fs.Path;
import org.apache.paimon.options.ConfigOption;
import org.apache.paimon.options.ConfigOptions;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.options.Options;
import org.apache.paimon.options.description.DescribedEnum;
import org.apache.paimon.options.description.Description;
import org.apache.paimon.options.description.InlineElement;
import org.apache.paimon.options.description.TextElement;
import org.apache.paimon.utils.StringUtils;

public class CoreOptions
implements Serializable {
    public static final ConfigOption<Integer> BUCKET = ConfigOptions.key("bucket").intType().defaultValue(1).withDescription("Bucket number for file store.");
    @Documentation.Immutable
    public static final ConfigOption<String> BUCKET_KEY = ConfigOptions.key("bucket-key").stringType().noDefaultValue().withDescription(Description.builder().text("Specify the paimon distribution policy. Data is assigned to each bucket according to the hash value of bucket-key.").linebreak().text("If you specify multiple fields, delimiter is ','.").linebreak().text("If not specified, the primary key will be used; if there is no primary key, the full row will be used.").build());
    @Documentation.ExcludeFromDocumentation(value="Internal use only")
    public static final ConfigOption<String> PATH = ConfigOptions.key("path").stringType().noDefaultValue().withDescription("The file path of this table in the filesystem.");
    public static final ConfigOption<FileFormatType> FILE_FORMAT = ConfigOptions.key("file.format").enumType(FileFormatType.class).defaultValue(FileFormatType.ORC).withDescription("Specify the message format of data files, currently orc, parquet and avro are supported.");
    public static final ConfigOption<String> ORC_BLOOM_FILTER_COLUMNS = ConfigOptions.key("orc.bloom.filter.columns").stringType().noDefaultValue().withDescription("A comma-separated list of columns for which to create a bloom filter when writing.");
    public static final ConfigOption<Double> ORC_BLOOM_FILTER_FPP = ConfigOptions.key("orc.bloom.filter.fpp").doubleType().defaultValue(0.05).withDescription("Define the default false positive probability for bloom filters.");
    public static final ConfigOption<Map<String, String>> FILE_COMPRESSION_PER_LEVEL = ConfigOptions.key("file.compression.per.level").mapType().defaultValue(new HashMap()).withDescription("Define different compression policies for different level, you can add the conf like this: 'file.compression.per.level' = '0:lz4,1:zlib', for orc file format, the compression value could be NONE, ZLIB, SNAPPY, LZO, LZ4, for parquet file format, the compression value could be UNCOMPRESSED, SNAPPY, GZIP, LZO, BROTLI, LZ4, ZSTD.");
    public static final ConfigOption<String> FILE_COMPRESSION = ConfigOptions.key("file.compression").stringType().noDefaultValue().withDescription("Default file compression format, can be overridden by " + FILE_COMPRESSION_PER_LEVEL.key());
    public static final ConfigOption<FileFormatType> MANIFEST_FORMAT = ConfigOptions.key("manifest.format").enumType(FileFormatType.class).defaultValue(FileFormatType.AVRO).withDescription("Specify the message format of manifest files.");
    public static final ConfigOption<MemorySize> MANIFEST_TARGET_FILE_SIZE = ConfigOptions.key("manifest.target-file-size").memoryType().defaultValue(MemorySize.ofMebiBytes(8L)).withDescription("Suggested file size of a manifest file.");
    public static final ConfigOption<Integer> MANIFEST_MERGE_MIN_COUNT = ConfigOptions.key("manifest.merge-min-count").intType().defaultValue(30).withDescription("To avoid frequent manifest merges, this parameter specifies the minimum number of ManifestFileMeta to merge.");
    public static final ConfigOption<String> PARTITION_DEFAULT_NAME = ConfigOptions.key("partition.default-name").stringType().defaultValue("__DEFAULT_PARTITION__").withDescription("The default partition name in case the dynamic partition column value is null/empty string.");
    public static final ConfigOption<Integer> SNAPSHOT_NUM_RETAINED_MIN = ConfigOptions.key("snapshot.num-retained.min").intType().defaultValue(10).withDescription("The minimum number of completed snapshots to retain.");
    public static final ConfigOption<Integer> SNAPSHOT_NUM_RETAINED_MAX = ConfigOptions.key("snapshot.num-retained.max").intType().defaultValue(Integer.MAX_VALUE).withDescription("The maximum number of completed snapshots to retain.");
    public static final ConfigOption<Duration> SNAPSHOT_TIME_RETAINED = ConfigOptions.key("snapshot.time-retained").durationType().defaultValue(Duration.ofHours(1L)).withDescription("The maximum time of completed snapshots to retain.");
    public static final ConfigOption<Duration> CONTINUOUS_DISCOVERY_INTERVAL = ConfigOptions.key("continuous.discovery-interval").durationType().defaultValue(Duration.ofSeconds(10L)).withDescription("The discovery interval of continuous reading.");
    @Documentation.Immutable
    public static final ConfigOption<MergeEngine> MERGE_ENGINE = ConfigOptions.key("merge-engine").enumType(MergeEngine.class).defaultValue(MergeEngine.DEDUPLICATE).withDescription("Specify the merge engine for table with primary key.");
    public static final ConfigOption<Boolean> PARTIAL_UPDATE_IGNORE_DELETE = ConfigOptions.key("partial-update.ignore-delete").booleanType().defaultValue(false).withDescription("Whether to ignore delete records in partial-update mode.");
    @Documentation.Immutable
    public static final ConfigOption<WriteMode> WRITE_MODE = ConfigOptions.key("write-mode").enumType(WriteMode.class).defaultValue(WriteMode.AUTO).withDescription("Specify the write mode for table.");
    public static final ConfigOption<Boolean> WRITE_ONLY = ConfigOptions.key("write-only").booleanType().defaultValue(false).withDeprecatedKeys("write.compaction-skip").withDescription("If set to true, compactions and snapshot expiration will be skipped. This option is used along with dedicated compact jobs.");
    public static final ConfigOption<MemorySize> SOURCE_SPLIT_TARGET_SIZE = ConfigOptions.key("source.split.target-size").memoryType().defaultValue(MemorySize.ofMebiBytes(128L)).withDescription("Target size of a source split when scanning a bucket.");
    public static final ConfigOption<MemorySize> SOURCE_SPLIT_OPEN_FILE_COST = ConfigOptions.key("source.split.open-file-cost").memoryType().defaultValue(MemorySize.ofMebiBytes(4L)).withDescription("Open file cost of a source file. It is used to avoid reading too many files with a source split, which can be very slow.");
    public static final ConfigOption<MemorySize> WRITE_BUFFER_SIZE = ConfigOptions.key("write-buffer-size").memoryType().defaultValue(MemorySize.parse("256 mb")).withDescription("Amount of data to build up in memory before converting to a sorted on-disk file.");
    public static final ConfigOption<Boolean> WRITE_BUFFER_SPILLABLE = ConfigOptions.key("write-buffer-spillable").booleanType().noDefaultValue().withDescription("Whether the write buffer can be spillable. Enabled by default when using object storage.");
    public static final ConfigOption<MemorySize> WRITE_MANIFEST_CACHE = ConfigOptions.key("write-manifest-cache").memoryType().defaultValue(MemorySize.ofMebiBytes(0L)).withDescription("Cache size for reading manifest files for write initialization.");
    public static final ConfigOption<Integer> LOCAL_SORT_MAX_NUM_FILE_HANDLES = ConfigOptions.key("local-sort.max-num-file-handles").intType().defaultValue(128).withDescription("The maximal fan-in for external merge sort. It limits the number of file handles. If it is too small, may cause intermediate merging. But if it is too large, it will cause too many files opened at the same time, consume memory and lead to random reading.");
    public static final ConfigOption<MemorySize> PAGE_SIZE = ConfigOptions.key("page-size").memoryType().defaultValue(MemorySize.parse("64 kb")).withDescription("Memory page size.");
    public static final ConfigOption<MemorySize> TARGET_FILE_SIZE = ConfigOptions.key("target-file-size").memoryType().defaultValue(MemorySize.ofMebiBytes(128L)).withDescription("Target size of a file.");
    public static final ConfigOption<Integer> NUM_SORTED_RUNS_COMPACTION_TRIGGER = ConfigOptions.key("num-sorted-run.compaction-trigger").intType().defaultValue(5).withDescription("The sorted run number to trigger compaction. Includes level0 files (one file one sorted run) and high-level runs (one level one sorted run).");
    public static final ConfigOption<Integer> NUM_SORTED_RUNS_STOP_TRIGGER = ConfigOptions.key("num-sorted-run.stop-trigger").intType().noDefaultValue().withDescription("The number of sorted runs that trigger the stopping of writes, the default value is 'num-sorted-run.compaction-trigger' + 1.");
    public static final ConfigOption<Integer> NUM_LEVELS = ConfigOptions.key("num-levels").intType().noDefaultValue().withDescription("Total level number, for example, there are 3 levels, including 0,1,2 levels.");
    public static final ConfigOption<Boolean> COMMIT_FORCE_COMPACT = ConfigOptions.key("commit.force-compact").booleanType().defaultValue(false).withDescription("Whether to force a compaction before commit.");
    public static final ConfigOption<Integer> COMPACTION_MAX_SIZE_AMPLIFICATION_PERCENT = ConfigOptions.key("compaction.max-size-amplification-percent").intType().defaultValue(200).withDescription("The size amplification is defined as the amount (in percentage) of additional storage needed to store a single byte of data in the merge tree for changelog mode table.");
    public static final ConfigOption<Integer> COMPACTION_SIZE_RATIO = ConfigOptions.key("compaction.size-ratio").intType().defaultValue(1).withDescription("Percentage flexibility while comparing sorted run size for changelog mode table. If the candidate sorted run(s) size is 1% smaller than the next sorted run's size, then include next sorted run into this candidate set.");
    public static final ConfigOption<Integer> COMPACTION_MIN_FILE_NUM = ConfigOptions.key("compaction.min.file-num").intType().defaultValue(5).withDescription("For file set [f_0,...,f_N], the minimum file number which satisfies sum(size(f_i)) >= targetFileSize to trigger a compaction for append-only table. This value avoids almost-full-file to be compacted, which is not cost-effective.");
    public static final ConfigOption<Integer> COMPACTION_MAX_FILE_NUM = ConfigOptions.key("compaction.max.file-num").intType().defaultValue(50).withDeprecatedKeys("compaction.early-max.file-num").withDescription("For file set [f_0,...,f_N], the maximum file number to trigger a compaction for append-only table, even if sum(size(f_i)) < targetFileSize. This value avoids pending too much small files, which slows down the performance.");
    public static final ConfigOption<Integer> COMPACTION_MAX_SORTED_RUN_NUM = ConfigOptions.key("compaction.max-sorted-run-num").intType().defaultValue(Integer.MAX_VALUE).withDescription("The maximum sorted run number to pick for compaction. This value avoids merging too much sorted runs at the same time during compaction, which may lead to OutOfMemoryError.");
    public static final ConfigOption<ChangelogProducer> CHANGELOG_PRODUCER = ConfigOptions.key("changelog-producer").enumType(ChangelogProducer.class).defaultValue(ChangelogProducer.NONE).withDescription("Whether to double write to a changelog file. This changelog file keeps the details of data changes, it can be read directly during stream reads.");
    @Documentation.Immutable
    public static final ConfigOption<String> SEQUENCE_FIELD = ConfigOptions.key("sequence.field").stringType().noDefaultValue().withDescription("The field that generates the sequence number for primary key table, the sequence number determines which data is the most recent.");
    public static final ConfigOption<StartupMode> SCAN_MODE = ConfigOptions.key("scan.mode").enumType(StartupMode.class).defaultValue(StartupMode.DEFAULT).withDeprecatedKeys("log.scan").withDescription("Specify the scanning behavior of the source.");
    public static final ConfigOption<Long> SCAN_TIMESTAMP_MILLIS = ConfigOptions.key("scan.timestamp-millis").longType().noDefaultValue().withDeprecatedKeys("log.scan.timestamp-millis").withDescription("Optional timestamp used in case of \"from-timestamp\" scan mode.");
    public static final ConfigOption<Long> SCAN_SNAPSHOT_ID = ConfigOptions.key("scan.snapshot-id").longType().noDefaultValue().withDescription("Optional snapshot id used in case of \"from-snapshot\" or \"from-snapshot-full\" scan mode");
    public static final ConfigOption<Long> SCAN_BOUNDED_WATERMARK = ConfigOptions.key("scan.bounded.watermark").longType().noDefaultValue().withDescription("End condition \"watermark\" for bounded streaming mode. Stream reading will end when a larger watermark snapshot is encountered.");
    public static final ConfigOption<LogConsistency> LOG_CONSISTENCY = ConfigOptions.key("log.consistency").enumType(LogConsistency.class).defaultValue(LogConsistency.TRANSACTIONAL).withDescription("Specify the log consistency mode for table.");
    public static final ConfigOption<LogChangelogMode> LOG_CHANGELOG_MODE = ConfigOptions.key("log.changelog-mode").enumType(LogChangelogMode.class).defaultValue(LogChangelogMode.AUTO).withDescription("Specify the log changelog mode for table.");
    public static final ConfigOption<Boolean> LOG_SCAN_REMOVE_NORMALIZE = ConfigOptions.key("log.scan.remove-normalize").booleanType().defaultValue(false).withDescription("Whether to force the removal of the normalize node when streaming read. Note: This is dangerous and is likely to cause data errors if downstream is used to calculate aggregation and the input is not complete changelog.");
    public static final ConfigOption<String> LOG_KEY_FORMAT = ConfigOptions.key("log.key.format").stringType().defaultValue("json").withDescription("Specify the key message format of log system with primary key.");
    public static final ConfigOption<String> LOG_FORMAT = ConfigOptions.key("log.format").stringType().defaultValue("debezium-json").withDescription("Specify the message format of log system.");
    public static final ConfigOption<Boolean> AUTO_CREATE = ConfigOptions.key("auto-create").booleanType().defaultValue(false).withDescription("Whether to create underlying storage when reading and writing the table.");
    public static final ConfigOption<Boolean> STREAMING_READ_OVERWRITE = ConfigOptions.key("streaming-read-overwrite").booleanType().defaultValue(false).withDescription("Whether to read the changes from overwrite in streaming mode.");
    public static final ConfigOption<Boolean> DYNAMIC_PARTITION_OVERWRITE = ConfigOptions.key("dynamic-partition-overwrite").booleanType().defaultValue(true).withDescription("Whether only overwrite dynamic partition when overwriting a partitioned table with dynamic partition columns. Works only when the table has partition keys.");
    public static final ConfigOption<Duration> PARTITION_EXPIRATION_TIME = ConfigOptions.key("partition.expiration-time").durationType().noDefaultValue().withDescription("The expiration interval of a partition. A partition will be expired if it\u2018s lifetime is over this value. Partition time is extracted from the partition value.");
    public static final ConfigOption<Duration> PARTITION_EXPIRATION_CHECK_INTERVAL = ConfigOptions.key("partition.expiration-check-interval").durationType().defaultValue(Duration.ofHours(1L)).withDescription("The check interval of partition expiration.");
    public static final ConfigOption<String> PARTITION_TIMESTAMP_FORMATTER = ConfigOptions.key("partition.timestamp-formatter").stringType().noDefaultValue().withDescription(Description.builder().text("The formatter to format timestamp from string. It can be used with 'partition.timestamp-pattern' to create a formatter using the specified value.").list(TextElement.text("Default formatter is 'yyyy-MM-dd HH:mm:ss' and 'yyyy-MM-dd'."), TextElement.text("Supports multiple partition fields like '$year-$month-$day $hour:00:00'."), TextElement.text("The timestamp-formatter is compatible with Java's DateTimeFormatter.")).build());
    public static final ConfigOption<String> PARTITION_TIMESTAMP_PATTERN = ConfigOptions.key("partition.timestamp-pattern").stringType().noDefaultValue().withDescription(Description.builder().text("You can specify a pattern to get a timestamp from partitions. The formatter pattern is defined by 'partition.timestamp-formatter'.").list(TextElement.text("By default, read from the first field."), TextElement.text("If the timestamp in the partition is a single field called 'dt', you can use '$dt'."), TextElement.text("If it is spread across multiple fields for year, month, day, and hour, you can use '$year-$month-$day $hour:00:00'."), TextElement.text("If the timestamp is in fields dt and hour, you can use '$dt $hour:00:00'.")).build());
    public static final ConfigOption<Boolean> SCAN_PLAN_SORT_PARTITION = ConfigOptions.key("scan.plan-sort-partition").booleanType().defaultValue(false).withDescription(Description.builder().text("Whether to sort plan files by partition fields, this allows you to read according to the partition order, even if your partition writes are out of order.").linebreak().text("It is recommended that you use this for streaming read of the 'append-only' table. By default, streaming read will read the full snapshot first. In order to avoid the disorder reading for partitions, you can open this option.").build());
    @Documentation.Immutable
    public static final ConfigOption<String> PRIMARY_KEY = ConfigOptions.key("primary-key").stringType().noDefaultValue().withDescription("Define primary key by table options, cannot define primary key on DDL and table options at the same time.");
    @Documentation.Immutable
    public static final ConfigOption<String> PARTITION = ConfigOptions.key("partition").stringType().noDefaultValue().withDescription("Define partition by table options, cannot define partition on DDL and table options at the same time.");
    public static final ConfigOption<Float> LOOKUP_HASH_LOAD_FACTOR = ConfigOptions.key("lookup.hash-load-factor").floatType().defaultValue(Float.valueOf(0.75f)).withDescription("The index load factor for lookup.");
    public static final ConfigOption<Duration> LOOKUP_CACHE_FILE_RETENTION = ConfigOptions.key("lookup.cache-file-retention").durationType().defaultValue(Duration.ofHours(1L)).withDescription("The cached files retention time for lookup. After the file expires, if there is a need for access, it will be re-read from the DFS to build an index on the local disk.");
    public static final ConfigOption<MemorySize> LOOKUP_CACHE_MAX_DISK_SIZE = ConfigOptions.key("lookup.cache-max-disk-size").memoryType().defaultValue(MemorySize.MAX_VALUE).withDescription("Max disk size for lookup cache, you can use this option to limit the use of local disks.");
    public static final ConfigOption<MemorySize> LOOKUP_CACHE_MAX_MEMORY_SIZE = ConfigOptions.key("lookup.cache-max-memory-size").memoryType().defaultValue(MemorySize.parse("256 mb")).withDescription("Max memory size for lookup cache.");
    public static final ConfigOption<Integer> READ_BATCH_SIZE = ConfigOptions.key("read.batch-size").intType().defaultValue(1024).withDescription("Read batch size for orc and parquet.");
    public static final ConfigOption<String> CONSUMER_ID = ConfigOptions.key("consumer-id").stringType().noDefaultValue().withDescription("Consumer id for recording the offset of consumption in the storage.");
    @Deprecated
    @Documentation.ExcludeFromDocumentation(value="For compatibility with older versions")
    public static final ConfigOption<Boolean> APPEND_ONLY_ASSERT_DISORDER = ConfigOptions.key("append-only.assert-disorder").booleanType().defaultValue(true).withDescription("Should assert disorder files, this just for compatibility with older versions.");
    public static final ConfigOption<Integer> FULL_COMPACTION_DELTA_COMMITS = ConfigOptions.key("full-compaction.delta-commits").intType().noDefaultValue().withDescription("Full compaction will be constantly triggered after delta commits.");
    @Documentation.ExcludeFromDocumentation(value="Internal use only")
    public static final ConfigOption<Boolean> STREAMING_COMPACT = ConfigOptions.key("streaming-compact").booleanType().defaultValue(false).withDescription("Only used to force TableScan to construct 'ContinuousCompactorStartingScanner' and 'ContinuousCompactorFollowUpScanner' for dedicated streaming compaction job.");
    public static final ConfigOption<StreamingReadMode> STREAMING_READ_MODE = ConfigOptions.key("streaming-read-mode").enumType(StreamingReadMode.class).noDefaultValue().withDescription(Description.builder().text("The mode of streaming read that specifies to read the data of table file or log").linebreak().linebreak().text("Possible values:").linebreak().list(TextElement.text(StreamingReadMode.FILE.getValue() + ": Reads from the data of table file store.")).list(TextElement.text(StreamingReadMode.LOG.getValue() + ": Read from the data of table log store.")).build());
    private final Options options;

    public CoreOptions(Map<String, String> options) {
        this(Options.fromMap(options));
    }

    public CoreOptions(Options options) {
        this.options = options;
    }

    public static CoreOptions fromMap(Map<String, String> options) {
        return new CoreOptions(options);
    }

    public Options toConfiguration() {
        return this.options;
    }

    public Map<String, String> toMap() {
        return this.options.toMap();
    }

    public int bucket() {
        return this.options.get(BUCKET);
    }

    public Path path() {
        return CoreOptions.path(this.options.toMap());
    }

    public static Path path(Map<String, String> options) {
        return new Path(options.get(PATH.key()));
    }

    public static Path path(Options options) {
        return new Path(options.get(PATH));
    }

    public FileFormatType formatType() {
        return this.options.get(FILE_FORMAT);
    }

    public FileFormat fileFormat() {
        return CoreOptions.createFileFormat(this.options, FILE_FORMAT);
    }

    public FileFormat manifestFormat() {
        return CoreOptions.createFileFormat(this.options, MANIFEST_FORMAT);
    }

    public MemorySize manifestTargetSize() {
        return this.options.get(MANIFEST_TARGET_FILE_SIZE);
    }

    public MemorySize writeManifestCache() {
        return this.options.get(WRITE_MANIFEST_CACHE);
    }

    public String partitionDefaultName() {
        return this.options.get(PARTITION_DEFAULT_NAME);
    }

    public static FileFormat createFileFormat(Options options, ConfigOption<FileFormatType> formatOption) {
        FileFormatType formatIdentifier = options.get(formatOption);
        int readBatchSize = options.get(READ_BATCH_SIZE);
        return FileFormat.fromIdentifier(formatIdentifier.toString(), new FileFormatFactory.FormatContext(options.removePrefix(formatIdentifier + "."), readBatchSize));
    }

    public Map<Integer, String> fileCompressionPerLevel() {
        Map<String, String> levelCompressions = this.options.get(FILE_COMPRESSION_PER_LEVEL);
        return levelCompressions.entrySet().stream().collect(Collectors.toMap(e -> Integer.valueOf((String)e.getKey()), Map.Entry::getValue));
    }

    public String fileCompression() {
        return this.options.get(FILE_COMPRESSION);
    }

    public int snapshotNumRetainMin() {
        return this.options.get(SNAPSHOT_NUM_RETAINED_MIN);
    }

    public int snapshotNumRetainMax() {
        return this.options.get(SNAPSHOT_NUM_RETAINED_MAX);
    }

    public Duration snapshotTimeRetain() {
        return this.options.get(SNAPSHOT_TIME_RETAINED);
    }

    public int manifestMergeMinCount() {
        return this.options.get(MANIFEST_MERGE_MIN_COUNT);
    }

    public MergeEngine mergeEngine() {
        return this.options.get(MERGE_ENGINE);
    }

    public long splitTargetSize() {
        return this.options.get(SOURCE_SPLIT_TARGET_SIZE).getBytes();
    }

    public long splitOpenFileCost() {
        return this.options.get(SOURCE_SPLIT_OPEN_FILE_COST).getBytes();
    }

    public long writeBufferSize() {
        return this.options.get(WRITE_BUFFER_SIZE).getBytes();
    }

    public boolean writeBufferSpillable(boolean usingObjectStore) {
        return this.options.getOptional(WRITE_BUFFER_SPILLABLE).orElse(usingObjectStore);
    }

    public Duration continuousDiscoveryInterval() {
        return this.options.get(CONTINUOUS_DISCOVERY_INTERVAL);
    }

    public int localSortMaxNumFileHandles() {
        return this.options.get(LOCAL_SORT_MAX_NUM_FILE_HANDLES);
    }

    public int pageSize() {
        return (int)this.options.get(PAGE_SIZE).getBytes();
    }

    public long targetFileSize() {
        return this.options.get(TARGET_FILE_SIZE).getBytes();
    }

    public int numSortedRunCompactionTrigger() {
        return this.options.get(NUM_SORTED_RUNS_COMPACTION_TRIGGER);
    }

    public int numSortedRunStopTrigger() {
        Integer stopTrigger = this.options.get(NUM_SORTED_RUNS_STOP_TRIGGER);
        if (stopTrigger == null) {
            stopTrigger = this.numSortedRunCompactionTrigger() + 1;
        }
        return Math.max(this.numSortedRunCompactionTrigger(), stopTrigger);
    }

    public int numLevels() {
        Integer numLevels = this.options.get(NUM_LEVELS);
        int expectedRuns = this.maxSortedRunNum() == Integer.MAX_VALUE ? this.numSortedRunCompactionTrigger() : this.numSortedRunStopTrigger();
        numLevels = numLevels == null ? expectedRuns + 1 : numLevels;
        return numLevels;
    }

    public boolean commitForceCompact() {
        return this.options.get(COMMIT_FORCE_COMPACT);
    }

    public int maxSizeAmplificationPercent() {
        return this.options.get(COMPACTION_MAX_SIZE_AMPLIFICATION_PERCENT);
    }

    public int sortedRunSizeRatio() {
        return this.options.get(COMPACTION_SIZE_RATIO);
    }

    public int compactionMinFileNum() {
        return this.options.get(COMPACTION_MIN_FILE_NUM);
    }

    public int compactionMaxFileNum() {
        return this.options.get(COMPACTION_MAX_FILE_NUM);
    }

    public int maxSortedRunNum() {
        return this.options.get(COMPACTION_MAX_SORTED_RUN_NUM);
    }

    public ChangelogProducer changelogProducer() {
        return this.options.get(CHANGELOG_PRODUCER);
    }

    public boolean scanPlanSortPartition() {
        return this.options.get(SCAN_PLAN_SORT_PARTITION);
    }

    public StartupMode startupMode() {
        return CoreOptions.startupMode(this.options);
    }

    public static StartupMode startupMode(Options options) {
        StartupMode mode = options.get(SCAN_MODE);
        if (mode == StartupMode.DEFAULT) {
            if (options.getOptional(SCAN_TIMESTAMP_MILLIS).isPresent()) {
                return StartupMode.FROM_TIMESTAMP;
            }
            if (options.getOptional(SCAN_SNAPSHOT_ID).isPresent()) {
                return StartupMode.FROM_SNAPSHOT;
            }
            return StartupMode.LATEST_FULL;
        }
        if (mode == StartupMode.FULL) {
            return StartupMode.LATEST_FULL;
        }
        return mode;
    }

    public Long scanTimestampMills() {
        return this.options.get(SCAN_TIMESTAMP_MILLIS);
    }

    public Long scanBoundedWatermark() {
        return this.options.get(SCAN_BOUNDED_WATERMARK);
    }

    public Long scanSnapshotId() {
        return this.options.get(SCAN_SNAPSHOT_ID);
    }

    public Optional<String> sequenceField() {
        return this.options.getOptional(SEQUENCE_FIELD);
    }

    public WriteMode writeMode() {
        return this.options.get(WRITE_MODE);
    }

    public boolean writeOnly() {
        return this.options.get(WRITE_ONLY);
    }

    public boolean streamingReadOverwrite() {
        return this.options.get(STREAMING_READ_OVERWRITE);
    }

    public boolean dynamicPartitionOverwrite() {
        return this.options.get(DYNAMIC_PARTITION_OVERWRITE);
    }

    public Duration partitionExpireTime() {
        return this.options.get(PARTITION_EXPIRATION_TIME);
    }

    public Duration partitionExpireCheckInterval() {
        return this.options.get(PARTITION_EXPIRATION_CHECK_INTERVAL);
    }

    public String partitionTimestampFormatter() {
        return this.options.get(PARTITION_TIMESTAMP_FORMATTER);
    }

    public String partitionTimestampPattern() {
        return this.options.get(PARTITION_TIMESTAMP_PATTERN);
    }

    public int readBatchSize() {
        return this.options.get(READ_BATCH_SIZE);
    }

    public String consumerId() {
        return this.options.get(CONSUMER_ID);
    }

    public static StreamingReadMode streamReadType(Options options) {
        return options.get(STREAMING_READ_MODE);
    }

    public static void setDefaultValues(Options options) {
        if (options.contains(SCAN_TIMESTAMP_MILLIS) && !options.contains(SCAN_MODE)) {
            options.set(SCAN_MODE, StartupMode.FROM_TIMESTAMP);
        }
        if (options.contains(SCAN_SNAPSHOT_ID) && !options.contains(SCAN_MODE)) {
            options.set(SCAN_MODE, StartupMode.FROM_SNAPSHOT);
        }
    }

    public static List<ConfigOption<?>> getOptions() {
        Field[] fields = CoreOptions.class.getFields();
        ArrayList list = new ArrayList(fields.length);
        for (Field field : fields) {
            if (!ConfigOption.class.isAssignableFrom(field.getType())) continue;
            try {
                list.add((ConfigOption)field.get(CoreOptions.class));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return list;
    }

    public static Set<String> getImmutableOptionKeys() {
        Field[] fields = CoreOptions.class.getFields();
        HashSet<String> immutableKeys = new HashSet<String>(fields.length);
        for (Field field : fields) {
            if (!ConfigOption.class.isAssignableFrom(field.getType()) || field.getAnnotation(Documentation.Immutable.class) == null) continue;
            try {
                immutableKeys.add(((ConfigOption)field.get(CoreOptions.class)).key());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return immutableKeys;
    }

    public static enum StreamingReadMode implements DescribedEnum
    {
        LOG("log", "Reads from the log store."),
        FILE("file", "Reads from the file store.");

        private final String value;
        private final String description;

        private StreamingReadMode(String value, String description) {
            this.value = value;
            this.description = description;
        }

        public String toString() {
            return this.value;
        }

        @Override
        public InlineElement getDescription() {
            return TextElement.text(this.description);
        }

        public String getValue() {
            return this.value;
        }

        @VisibleForTesting
        public static StreamingReadMode fromValue(String value) {
            for (StreamingReadMode formatType : StreamingReadMode.values()) {
                if (!formatType.value.equals(value)) continue;
                return formatType;
            }
            throw new IllegalArgumentException(String.format("Invalid format type %s, only support [%s]", value, StringUtils.join(Arrays.stream(StreamingReadMode.values()).iterator(), ",")));
        }
    }

    public static enum FileFormatType implements DescribedEnum
    {
        ORC("orc", "ORC file format."),
        PARQUET("parquet", "Parquet file format."),
        AVRO("avro", "Avro file format.");

        private final String value;
        private final String description;

        private FileFormatType(String value, String description) {
            this.value = value;
            this.description = description;
        }

        public String toString() {
            return this.value;
        }

        @Override
        public InlineElement getDescription() {
            return TextElement.text(this.description);
        }

        @VisibleForTesting
        public static FileFormatType fromValue(String value) {
            for (FileFormatType formatType : FileFormatType.values()) {
                if (!formatType.value.equals(value)) continue;
                return formatType;
            }
            throw new IllegalArgumentException(String.format("Invalid format type %s, only support [%s]", value, StringUtils.join(Arrays.stream(FileFormatType.values()).iterator(), ",")));
        }
    }

    public static enum ChangelogProducer implements DescribedEnum
    {
        NONE("none", "No changelog file."),
        INPUT("input", "Double write to a changelog file when flushing memory table, the changelog is from input."),
        FULL_COMPACTION("full-compaction", "Generate changelog files with each full compaction."),
        LOOKUP("lookup", "Generate changelog files through 'lookup' before committing the data writing.");

        private final String value;
        private final String description;

        private ChangelogProducer(String value, String description) {
            this.value = value;
            this.description = description;
        }

        public String toString() {
            return this.value;
        }

        @Override
        public InlineElement getDescription() {
            return TextElement.text(this.description);
        }
    }

    public static enum LogChangelogMode implements DescribedEnum
    {
        AUTO("auto", "Upsert for table with primary key, all for table without primary key."),
        ALL("all", "The log system stores all changes including UPDATE_BEFORE."),
        UPSERT("upsert", "The log system does not store the UPDATE_BEFORE changes, the log consumed job will automatically add the normalized node, relying on the state to generate the required update_before.");

        private final String value;
        private final String description;

        private LogChangelogMode(String value, String description) {
            this.value = value;
            this.description = description;
        }

        public String toString() {
            return this.value;
        }

        @Override
        public InlineElement getDescription() {
            return TextElement.text(this.description);
        }
    }

    public static enum LogConsistency implements DescribedEnum
    {
        TRANSACTIONAL("transactional", "Only the data after the checkpoint can be seen by readers, the latency depends on checkpoint interval."),
        EVENTUAL("eventual", "Immediate data visibility, you may see some intermediate states, but eventually the right results will be produced, only works for table with primary key.");

        private final String value;
        private final String description;

        private LogConsistency(String value, String description) {
            this.value = value;
            this.description = description;
        }

        public String toString() {
            return this.value;
        }

        @Override
        public InlineElement getDescription() {
            return TextElement.text(this.description);
        }
    }

    public static enum StartupMode implements DescribedEnum
    {
        DEFAULT("default", "Determines actual startup mode according to other table properties. If \"scan.timestamp-millis\" is set the actual startup mode will be \"from-timestamp\", and if \"scan.snapshot-id\" is set the actual startup mode will be \"from-snapshot\". Otherwise the actual startup mode will be \"latest-full\"."),
        LATEST_FULL("latest-full", "For streaming sources, produces the latest snapshot on the table upon first startup, and continue to read the latest changes. For batch sources, just produce the latest snapshot but does not read new changes."),
        FULL("full", "Deprecated. Same as \"latest-full\"."),
        LATEST("latest", "For streaming sources, continuously reads latest changes without producing a snapshot at the beginning. For batch sources, behaves the same as the \"latest-full\" startup mode."),
        COMPACTED_FULL("compacted-full", "For streaming sources, produces a snapshot after the latest compaction on the table upon first startup, and continue to read the latest changes. For batch sources, just produce a snapshot after the latest compaction but does not read new changes. Snapshots of full compaction are picked when scheduled full-compaction is enabled."),
        FROM_TIMESTAMP("from-timestamp", "For streaming sources, continuously reads changes starting from timestamp specified by \"scan.timestamp-millis\", without producing a snapshot at the beginning. For batch sources, produces a snapshot at timestamp specified by \"scan.timestamp-millis\" but does not read new changes."),
        FROM_SNAPSHOT("from-snapshot", "For streaming sources, continuously reads changes starting from snapshot specified by \"scan.snapshot-id\", without producing a snapshot at the beginning. For batch sources, produces a snapshot specified by \"scan.snapshot-id\" but does not read new changes."),
        FROM_SNAPSHOT_FULL("from-snapshot-full", "For streaming sources, produces from snapshot specified by \"scan.snapshot-id\" on the table upon first startup, and continuously reads changes. For batch sources, produces a snapshot specified by \"scan.snapshot-id\" but does not read new changes.");

        private final String value;
        private final String description;

        private StartupMode(String value, String description) {
            this.value = value;
            this.description = description;
        }

        public String toString() {
            return this.value;
        }

        @Override
        public InlineElement getDescription() {
            return TextElement.text(this.description);
        }
    }

    public static enum MergeEngine implements DescribedEnum
    {
        DEDUPLICATE("deduplicate", "De-duplicate and keep the last row."),
        PARTIAL_UPDATE("partial-update", "Partial update non-null fields."),
        AGGREGATE("aggregation", "Aggregate fields with same primary key.");

        private final String value;
        private final String description;

        private MergeEngine(String value, String description) {
            this.value = value;
            this.description = description;
        }

        public String toString() {
            return this.value;
        }

        @Override
        public InlineElement getDescription() {
            return TextElement.text(this.description);
        }
    }
}

