/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon;

import java.util.Comparator;
import java.util.function.Supplier;
import org.apache.paimon.AbstractFileStore;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FileFormatDiscover;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.manifest.ManifestCacheFilter;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;
import org.apache.paimon.operation.KeyValueFileStoreRead;
import org.apache.paimon.operation.KeyValueFileStoreScan;
import org.apache.paimon.operation.KeyValueFileStoreWrite;
import org.apache.paimon.schema.KeyValueFieldsExtractor;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.KeyComparatorSupplier;

public class KeyValueFileStore
extends AbstractFileStore<KeyValue> {
    private static final long serialVersionUID = 1L;
    private final RowType bucketKeyType;
    private final RowType keyType;
    private final RowType valueType;
    private final KeyValueFieldsExtractor keyValueFieldsExtractor;
    private final Supplier<Comparator<InternalRow>> keyComparatorSupplier;
    private final MergeFunctionFactory<KeyValue> mfFactory;

    public KeyValueFileStore(FileIO fileIO, SchemaManager schemaManager, long schemaId, CoreOptions options, RowType partitionType, RowType bucketKeyType, RowType keyType, RowType valueType, KeyValueFieldsExtractor keyValueFieldsExtractor, MergeFunctionFactory<KeyValue> mfFactory) {
        super(fileIO, schemaManager, schemaId, options, partitionType);
        this.bucketKeyType = bucketKeyType;
        this.keyType = keyType;
        this.valueType = valueType;
        this.keyValueFieldsExtractor = keyValueFieldsExtractor;
        this.mfFactory = mfFactory;
        this.keyComparatorSupplier = new KeyComparatorSupplier(keyType);
    }

    @Override
    public KeyValueFileStoreScan newScan() {
        return this.newScan(false);
    }

    public KeyValueFileStoreRead newRead() {
        return new KeyValueFileStoreRead(this.fileIO, this.schemaManager, this.schemaId, this.keyType, this.valueType, this.newKeyComparator(), this.mfFactory, FileFormatDiscover.of(this.options), this.pathFactory(), this.keyValueFieldsExtractor);
    }

    public KeyValueFileStoreWrite newWrite(String commitUser) {
        return this.newWrite(commitUser, null);
    }

    public KeyValueFileStoreWrite newWrite(String commitUser, ManifestCacheFilter manifestFilter) {
        return new KeyValueFileStoreWrite(this.fileIO, this.schemaManager, this.schemaId, commitUser, this.keyType, this.valueType, this.keyComparatorSupplier, this.mfFactory, this.pathFactory(), this.snapshotManager(), this.newScan(true).withManifestCacheFilter(manifestFilter), this.options, this.keyValueFieldsExtractor);
    }

    private KeyValueFileStoreScan newScan(boolean forWrite) {
        return new KeyValueFileStoreScan(this.partitionType, this.bucketKeyType, this.keyType, this.snapshotManager(), this.schemaManager, this.schemaId, this.keyValueFieldsExtractor, this.manifestFileFactory(forWrite), this.manifestListFactory(forWrite), this.options.bucket(), forWrite);
    }

    @Override
    public Comparator<InternalRow> newKeyComparator() {
        return this.keyComparatorSupplier.get();
    }
}

