/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.casting;

import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeChecks;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.utils.DateTimeUtils;
import org.apache.paimon.utils.DecimalUtils;
import org.apache.paimon.utils.StringUtils;

public class CastExecutors {
    private static final CastExecutor<?, ?> IDENTITY_CAST_EXECUTOR = value -> value;

    @Nullable
    public static CastExecutor<?, ?> resolve(DataType inputType, DataType outputType) {
        switch (inputType.getTypeRoot()) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: {
                switch (outputType.getTypeRoot()) {
                    case TINYINT: {
                        return value -> ((Number)value).byteValue();
                    }
                    case SMALLINT: {
                        return value -> ((Number)value).shortValue();
                    }
                    case INTEGER: {
                        return value -> ((Number)value).intValue();
                    }
                    case BIGINT: {
                        return value -> ((Number)value).longValue();
                    }
                    case FLOAT: {
                        return value -> Float.valueOf(((Number)value).floatValue());
                    }
                    case DOUBLE: {
                        return value -> ((Number)value).doubleValue();
                    }
                    case DECIMAL: {
                        DecimalType decimalType = (DecimalType)outputType;
                        return value -> {
                            Number number = (Number)value;
                            switch (inputType.getTypeRoot()) {
                                case TINYINT: 
                                case SMALLINT: 
                                case INTEGER: 
                                case BIGINT: {
                                    return DecimalUtils.castFrom(number.longValue(), decimalType.getPrecision(), decimalType.getScale());
                                }
                            }
                            return DecimalUtils.castFrom(number.doubleValue(), decimalType.getPrecision(), decimalType.getScale());
                        };
                    }
                }
                return null;
            }
            case DECIMAL: {
                switch (outputType.getTypeRoot()) {
                    case TINYINT: {
                        return value -> (byte)DecimalUtils.castToIntegral((Decimal)value);
                    }
                    case SMALLINT: {
                        return value -> (short)DecimalUtils.castToIntegral((Decimal)value);
                    }
                    case INTEGER: {
                        return value -> (int)DecimalUtils.castToIntegral((Decimal)value);
                    }
                    case BIGINT: {
                        return value -> DecimalUtils.castToIntegral((Decimal)value);
                    }
                    case FLOAT: {
                        return value -> Float.valueOf((float)DecimalUtils.doubleValue((Decimal)value));
                    }
                    case DOUBLE: {
                        return value -> DecimalUtils.doubleValue((Decimal)value);
                    }
                    case DECIMAL: {
                        DecimalType decimalType = (DecimalType)outputType;
                        return value -> DecimalUtils.castToDecimal((Decimal)value, decimalType.getPrecision(), decimalType.getScale());
                    }
                }
                return null;
            }
            case CHAR: 
            case VARCHAR: {
                if (outputType.getTypeRoot() == DataTypeRoot.CHAR || outputType.getTypeRoot() == DataTypeRoot.VARCHAR) {
                    boolean targetCharType = outputType.getTypeRoot() == DataTypeRoot.CHAR;
                    int targetLength = DataTypeChecks.getLength(outputType);
                    return value -> {
                        BinaryString result;
                        String strVal = value.toString();
                        BinaryString strData = BinaryString.fromString(strVal);
                        if (strData.numChars() > targetLength) {
                            result = BinaryString.fromString(strVal.substring(0, targetLength));
                        } else if (strData.numChars() < targetLength) {
                            if (targetCharType) {
                                int padLength = targetLength - strData.numChars();
                                BinaryString padString = BinaryString.blankString(padLength);
                                result = StringUtils.concat(strData, padString);
                            } else {
                                result = strData;
                            }
                        } else {
                            result = strData;
                        }
                        return result;
                    };
                }
                if (outputType.getTypeRoot() == DataTypeRoot.VARBINARY) {
                    int targetLength = DataTypeChecks.getLength(outputType);
                    return value -> {
                        byte[] byteArrayTerm = ((BinaryString)value).toBytes();
                        if (byteArrayTerm.length <= targetLength) {
                            return byteArrayTerm;
                        }
                        return Arrays.copyOf(byteArrayTerm, targetLength);
                    };
                }
                return null;
            }
            case BINARY: 
            case VARBINARY: {
                if (outputType.getTypeRoot() == DataTypeRoot.BINARY || outputType.getTypeRoot() == DataTypeRoot.VARBINARY) {
                    boolean targetBinaryType = outputType.getTypeRoot() == DataTypeRoot.BINARY;
                    int targetLength = DataTypeChecks.getLength(outputType);
                    return value -> {
                        byte[] bytes = (byte[])value;
                        if (((byte[])value).length == targetLength) {
                            return value;
                        }
                        if (targetBinaryType) {
                            if (bytes.length == targetLength) {
                                return bytes;
                            }
                            return Arrays.copyOf(bytes, targetLength);
                        }
                        if (bytes.length <= targetLength) {
                            return bytes;
                        }
                        return Arrays.copyOf(bytes, targetLength);
                    };
                }
                return null;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                switch (outputType.getTypeRoot()) {
                    case DATE: {
                        return value -> (int)(((Timestamp)value).getMillisecond() / 86400000L);
                    }
                    case TIMESTAMP_WITHOUT_TIME_ZONE: {
                        return value -> DateTimeUtils.truncate((Timestamp)value, ((TimestampType)outputType).getPrecision());
                    }
                    case TIME_WITHOUT_TIME_ZONE: {
                        return value -> (int)(((Timestamp)value).getMillisecond() % 86400000L);
                    }
                }
                return null;
            }
            case TIME_WITHOUT_TIME_ZONE: {
                if (outputType.getTypeRoot() == DataTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE) {
                    return value -> (int)(((Timestamp)value).getMillisecond() % 86400000L);
                }
                return null;
            }
        }
        return null;
    }

    public static CastExecutor<?, ?> identityCastExecutor() {
        return IDENTITY_CAST_EXECUTOR;
    }
}

