/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.catalog;

import java.util.HashMap;
import java.util.Map;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.FileStoreTableFactory;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.system.SystemTableLoader;
import org.apache.paimon.utils.StringUtils;

public abstract class AbstractCatalog
implements Catalog {
    protected static final String DB_SUFFIX = ".db";
    protected static final String TABLE_DEFAULT_OPTION_PREFIX = "table-default.";
    protected final FileIO fileIO;
    protected final Map<String, String> tableDefaultOptions;

    protected AbstractCatalog(FileIO fileIO) {
        this.fileIO = fileIO;
        this.tableDefaultOptions = new HashMap<String, String>();
    }

    protected AbstractCatalog(FileIO fileIO, Map<String, String> options) {
        this.fileIO = fileIO;
        this.tableDefaultOptions = new HashMap<String, String>();
        options.keySet().stream().filter(key -> key.startsWith(TABLE_DEFAULT_OPTION_PREFIX)).forEach(key -> this.tableDefaultOptions.put(key.substring(TABLE_DEFAULT_OPTION_PREFIX.length()), (String)options.get(key)));
    }

    @Override
    public Table getTable(Identifier identifier) throws Catalog.TableNotExistException {
        if (this.isSystemTable(identifier)) {
            String[] splits = this.tableAndSystemName(identifier);
            String tableName = splits[0];
            String type = splits[1];
            FileStoreTable originTable = this.getDataTable(new Identifier(identifier.getDatabaseName(), tableName));
            Table table = SystemTableLoader.load(type, this.fileIO, originTable);
            if (table == null) {
                throw new Catalog.TableNotExistException(identifier);
            }
            return table;
        }
        return this.getDataTable(identifier);
    }

    private FileStoreTable getDataTable(Identifier identifier) throws Catalog.TableNotExistException {
        TableSchema tableSchema = this.getDataTableSchema(identifier);
        return FileStoreTableFactory.create(this.fileIO, this.getDataTableLocation(identifier), tableSchema);
    }

    protected Path databasePath(String database) {
        return new Path(this.warehouse(), database + DB_SUFFIX);
    }

    protected abstract String warehouse();

    protected abstract TableSchema getDataTableSchema(Identifier var1) throws Catalog.TableNotExistException;

    @VisibleForTesting
    public Path getDataTableLocation(Identifier identifier) {
        if (identifier.getObjectName().contains("$")) {
            throw new IllegalArgumentException(String.format("Table name[%s] cannot contain '%s' separator", identifier.getObjectName(), "$"));
        }
        return new Path(this.databasePath(identifier.getDatabaseName()), identifier.getObjectName());
    }

    private boolean isSystemTable(Identifier identifier) {
        return identifier.getObjectName().contains("$");
    }

    protected void checkNotSystemTable(Identifier identifier, String method) {
        if (this.isSystemTable(identifier)) {
            throw new IllegalArgumentException(String.format("Cannot '%s' for system table '%s', please use data table.", method, identifier));
        }
    }

    protected void copyTableDefaultOptions(Map<String, String> options) {
        this.tableDefaultOptions.forEach(options::putIfAbsent);
    }

    private String[] tableAndSystemName(Identifier identifier) {
        String[] splits = StringUtils.split(identifier.getObjectName(), "$");
        if (splits.length != 2) {
            throw new IllegalArgumentException("System table can only contain one '$' separator, but this is: " + identifier.getObjectName());
        }
        return splits;
    }
}

