/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.catalog;

import java.util.List;
import java.util.Optional;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.catalog.CatalogLock;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.table.Table;

@Public
public interface Catalog
extends AutoCloseable {
    public static final String DEFAULT_DATABASE = "default";
    public static final String SYSTEM_TABLE_SPLITTER = "$";

    public Optional<CatalogLock.Factory> lockFactory();

    public List<String> listDatabases();

    public boolean databaseExists(String var1);

    public void createDatabase(String var1, boolean var2) throws DatabaseAlreadyExistException;

    public void dropDatabase(String var1, boolean var2, boolean var3) throws DatabaseNotExistException, DatabaseNotEmptyException;

    public Table getTable(Identifier var1) throws TableNotExistException;

    public List<String> listTables(String var1) throws DatabaseNotExistException;

    default public boolean tableExists(Identifier identifier) {
        try {
            return this.getTable(identifier) != null;
        }
        catch (TableNotExistException e) {
            return false;
        }
    }

    public void dropTable(Identifier var1, boolean var2) throws TableNotExistException;

    public void createTable(Identifier var1, Schema var2, boolean var3) throws TableAlreadyExistException, DatabaseNotExistException;

    public void renameTable(Identifier var1, Identifier var2, boolean var3) throws TableNotExistException, TableAlreadyExistException;

    public void alterTable(Identifier var1, List<SchemaChange> var2, boolean var3) throws TableNotExistException;

    default public boolean caseSensitive() {
        return true;
    }

    public static class TableNotExistException
    extends Exception {
        private static final String MSG = "Table %s does not exist.";
        private final Identifier identifier;

        public TableNotExistException(Identifier identifier) {
            this(identifier, null);
        }

        public TableNotExistException(Identifier identifier, Throwable cause) {
            super(String.format(MSG, identifier.getFullName()), cause);
            this.identifier = identifier;
        }

        public Identifier identifier() {
            return this.identifier;
        }
    }

    public static class TableAlreadyExistException
    extends Exception {
        private static final String MSG = "Table %s already exists.";
        private final Identifier identifier;

        public TableAlreadyExistException(Identifier identifier) {
            this(identifier, null);
        }

        public TableAlreadyExistException(Identifier identifier, Throwable cause) {
            super(String.format(MSG, identifier.getFullName()), cause);
            this.identifier = identifier;
        }

        public Identifier identifier() {
            return this.identifier;
        }
    }

    public static class DatabaseNotExistException
    extends Exception {
        private static final String MSG = "Database %s does not exist.";
        private final String database;

        public DatabaseNotExistException(String database, Throwable cause) {
            super(String.format(MSG, database), cause);
            this.database = database;
        }

        public DatabaseNotExistException(String database) {
            this(database, null);
        }

        public String database() {
            return this.database;
        }
    }

    public static class DatabaseAlreadyExistException
    extends Exception {
        private static final String MSG = "Database %s already exists.";
        private final String database;

        public DatabaseAlreadyExistException(String database, Throwable cause) {
            super(String.format(MSG, database), cause);
            this.database = database;
        }

        public DatabaseAlreadyExistException(String database) {
            this(database, null);
        }

        public String database() {
            return this.database;
        }
    }

    public static class DatabaseNotEmptyException
    extends Exception {
        private static final String MSG = "Database %s is not empty.";
        private final String database;

        public DatabaseNotEmptyException(String database, Throwable cause) {
            super(String.format(MSG, database), cause);
            this.database = database;
        }

        public DatabaseNotEmptyException(String database) {
            this(database, null);
        }

        public String database() {
            return this.database;
        }
    }
}

