/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.catalog;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.utils.Preconditions;

@Public
public interface CatalogFactory {
    public String identifier();

    public Catalog create(FileIO var1, Path var2, CatalogContext var3);

    public static Path warehouse(CatalogContext context) {
        String warehouse = Preconditions.checkNotNull(context.options().get(CatalogOptions.WAREHOUSE), "Paimon '" + CatalogOptions.WAREHOUSE.key() + "' path must be set");
        return new Path(warehouse);
    }

    public static Catalog createCatalog(CatalogContext options) {
        return CatalogFactory.createCatalog(options, Thread.currentThread().getContextClassLoader());
    }

    public static Catalog createCatalog(CatalogContext context, ClassLoader classLoader) {
        FileIO fileIO;
        String warehouse = CatalogFactory.warehouse(context).toUri().toString();
        String metastore = context.options().get(CatalogOptions.METASTORE);
        ArrayList factories = new ArrayList();
        ServiceLoader.load(CatalogFactory.class, classLoader).iterator().forEachRemaining(f -> {
            if (f.identifier().equals(metastore)) {
                factories.add(f);
            }
        });
        if (factories.size() != 1) {
            throw new RuntimeException("Found " + factories.size() + " classes implementing " + CatalogFactory.class.getName() + " with metastore " + metastore + ". They are:\n" + factories.stream().map(t -> t.getClass().getName()).collect(Collectors.joining("\n")));
        }
        Path warehousePath = new Path(warehouse);
        try {
            fileIO = FileIO.get(warehousePath, context);
            if (fileIO.exists(warehousePath)) {
                Preconditions.checkArgument(fileIO.isDir(warehousePath), "The %s path '%s' should be a directory.", CatalogOptions.WAREHOUSE.key(), warehouse);
            } else {
                fileIO.mkdirs(warehousePath);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return ((CatalogFactory)factories.get(0)).create(fileIO, warehousePath, context);
    }
}

