/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.catalog;

import java.io.Serializable;
import java.util.Objects;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.fs.Path;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.StringUtils;

@Public
public class Identifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String database;
    private final String table;

    public Identifier(String database, String table) {
        this.database = database;
        this.table = table;
    }

    public String getDatabaseName() {
        return this.database;
    }

    public String getObjectName() {
        return this.table;
    }

    public String getFullName() {
        return String.format("%s.%s", this.database, this.table);
    }

    public String getEscapedFullName() {
        return this.getEscapedFullName('`');
    }

    public String getEscapedFullName(char escapeChar) {
        return String.format("%c%s%c.%c%s%c", Character.valueOf(escapeChar), this.database, Character.valueOf(escapeChar), Character.valueOf(escapeChar), this.table, Character.valueOf(escapeChar));
    }

    public static Identifier create(String db, String table) {
        return new Identifier(db, table);
    }

    public static Identifier fromString(String fullName) {
        Preconditions.checkArgument(!StringUtils.isNullOrWhitespaceOnly(fullName), "fullName cannot be null or empty");
        String[] paths = fullName.split("\\.");
        if (paths.length != 2) {
            throw new IllegalArgumentException(String.format("Cannot get splits from '%s' to get database and table", fullName));
        }
        return new Identifier(paths[0], paths[1]);
    }

    public static Identifier fromPath(Path tablePath) {
        return Identifier.fromPath(tablePath.getPath());
    }

    public static Identifier fromPath(String tablePath) {
        String[] paths = tablePath.split("/");
        if (paths.length < 2) {
            throw new IllegalArgumentException(String.format("Path '%s' is not a legacy path, please use catalog table path instead: 'warehouse_path/your_database.db/your_table'.", tablePath));
        }
        String database = paths[paths.length - 2];
        database = database.substring(0, database.length() - ".db".length());
        return new Identifier(database, paths[paths.length - 1]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Identifier that = (Identifier)o;
        return Objects.equals(this.database, that.database) && Objects.equals(this.table, that.table);
    }

    public int hashCode() {
        return Objects.hash(this.database, this.table);
    }

    public String toString() {
        return "Identifier{database='" + this.database + '\'' + ", table='" + this.table + '\'' + '}';
    }
}

