/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.compact;

import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.paimon.compact.CompactManager;
import org.apache.paimon.compact.CompactResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompactFutureManager
implements CompactManager {
    private static final Logger LOG = LoggerFactory.getLogger(CompactFutureManager.class);
    protected Future<CompactResult> taskFuture;

    @Override
    public void cancelCompaction() {
        if (this.taskFuture != null && !this.taskFuture.isCancelled()) {
            this.taskFuture.cancel(true);
        }
    }

    protected final Optional<CompactResult> innerGetCompactionResult(boolean blocking) throws ExecutionException, InterruptedException {
        if (this.taskFuture != null && (blocking || this.taskFuture.isDone())) {
            CompactResult result;
            try {
                result = this.taskFuture.get();
            }
            catch (CancellationException e) {
                LOG.info("Compaction future is cancelled", (Throwable)e);
                this.taskFuture = null;
                return Optional.empty();
            }
            this.taskFuture = null;
            return Optional.of(result);
        }
        return Optional.empty();
    }
}

