/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.utils.ArrayUtils;

@Public
public final class GenericArray
implements InternalArray,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object array;
    private final int size;
    private final boolean isPrimitiveArray;

    public GenericArray(Object[] array) {
        this(array, array.length, false);
    }

    public GenericArray(int[] primitiveArray) {
        this(primitiveArray, primitiveArray.length, true);
    }

    public GenericArray(long[] primitiveArray) {
        this(primitiveArray, primitiveArray.length, true);
    }

    public GenericArray(float[] primitiveArray) {
        this(primitiveArray, primitiveArray.length, true);
    }

    public GenericArray(double[] primitiveArray) {
        this(primitiveArray, primitiveArray.length, true);
    }

    public GenericArray(short[] primitiveArray) {
        this(primitiveArray, primitiveArray.length, true);
    }

    public GenericArray(byte[] primitiveArray) {
        this(primitiveArray, primitiveArray.length, true);
    }

    public GenericArray(boolean[] primitiveArray) {
        this(primitiveArray, primitiveArray.length, true);
    }

    private GenericArray(Object array, int size, boolean isPrimitiveArray) {
        this.array = array;
        this.size = size;
        this.isPrimitiveArray = isPrimitiveArray;
    }

    public boolean isPrimitiveArray() {
        return this.isPrimitiveArray;
    }

    public Object[] toObjectArray() {
        if (this.isPrimitiveArray) {
            Class<?> arrayClass = this.array.getClass();
            if (int[].class.equals(arrayClass)) {
                return ArrayUtils.toObject((int[])this.array);
            }
            if (long[].class.equals(arrayClass)) {
                return ArrayUtils.toObject((long[])this.array);
            }
            if (float[].class.equals(arrayClass)) {
                return ArrayUtils.toObject((float[])this.array);
            }
            if (double[].class.equals(arrayClass)) {
                return ArrayUtils.toObject((double[])this.array);
            }
            if (short[].class.equals(arrayClass)) {
                return ArrayUtils.toObject((short[])this.array);
            }
            if (byte[].class.equals(arrayClass)) {
                return ArrayUtils.toObject((byte[])this.array);
            }
            if (boolean[].class.equals(arrayClass)) {
                return ArrayUtils.toObject((boolean[])this.array);
            }
            throw new RuntimeException("Unsupported primitive array: " + arrayClass);
        }
        return (Object[])this.array;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isNullAt(int pos) {
        return !this.isPrimitiveArray && ((Object[])this.array)[pos] == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericArray that = (GenericArray)o;
        return this.size == that.size && this.isPrimitiveArray == that.isPrimitiveArray && Objects.deepEquals(this.array, that.array);
    }

    public int hashCode() {
        int result = Objects.hash(this.size, this.isPrimitiveArray);
        result = 31 * result + Arrays.deepHashCode(new Object[]{this.array});
        return result;
    }

    @Override
    public boolean getBoolean(int pos) {
        return this.isPrimitiveArray ? ((boolean[])this.array)[pos] : (Boolean)this.getObject(pos);
    }

    @Override
    public byte getByte(int pos) {
        return this.isPrimitiveArray ? ((byte[])this.array)[pos] : (Byte)this.getObject(pos);
    }

    @Override
    public short getShort(int pos) {
        return this.isPrimitiveArray ? ((short[])this.array)[pos] : (Short)this.getObject(pos);
    }

    @Override
    public int getInt(int pos) {
        return this.isPrimitiveArray ? ((int[])this.array)[pos] : (Integer)this.getObject(pos);
    }

    @Override
    public long getLong(int pos) {
        return this.isPrimitiveArray ? ((long[])this.array)[pos] : (Long)this.getObject(pos);
    }

    @Override
    public float getFloat(int pos) {
        return this.isPrimitiveArray ? ((float[])this.array)[pos] : ((Float)this.getObject(pos)).floatValue();
    }

    @Override
    public double getDouble(int pos) {
        return this.isPrimitiveArray ? ((double[])this.array)[pos] : (Double)this.getObject(pos);
    }

    @Override
    public byte[] getBinary(int pos) {
        return (byte[])this.getObject(pos);
    }

    @Override
    public BinaryString getString(int pos) {
        return (BinaryString)this.getObject(pos);
    }

    @Override
    public Decimal getDecimal(int pos, int precision, int scale) {
        return (Decimal)this.getObject(pos);
    }

    @Override
    public Timestamp getTimestamp(int pos, int precision) {
        return (Timestamp)this.getObject(pos);
    }

    @Override
    public InternalRow getRow(int pos, int numFields) {
        return (InternalRow)this.getObject(pos);
    }

    @Override
    public InternalArray getArray(int pos) {
        return (InternalArray)this.getObject(pos);
    }

    @Override
    public InternalMap getMap(int pos) {
        return (InternalMap)this.getObject(pos);
    }

    private Object getObject(int pos) {
        return ((Object[])this.array)[pos];
    }

    private boolean anyNull() {
        for (Object element : (Object[])this.array) {
            if (element != null) continue;
            return true;
        }
        return false;
    }

    private void checkNoNull() {
        if (this.anyNull()) {
            throw new RuntimeException("Primitive array must not contain a null value.");
        }
    }

    @Override
    public boolean[] toBooleanArray() {
        if (this.isPrimitiveArray) {
            return (boolean[])this.array;
        }
        this.checkNoNull();
        return ArrayUtils.toPrimitive((Boolean[])this.array);
    }

    @Override
    public byte[] toByteArray() {
        if (this.isPrimitiveArray) {
            return (byte[])this.array;
        }
        this.checkNoNull();
        return ArrayUtils.toPrimitive((Byte[])this.array);
    }

    @Override
    public short[] toShortArray() {
        if (this.isPrimitiveArray) {
            return (short[])this.array;
        }
        this.checkNoNull();
        return ArrayUtils.toPrimitive((Short[])this.array);
    }

    @Override
    public int[] toIntArray() {
        if (this.isPrimitiveArray) {
            return (int[])this.array;
        }
        this.checkNoNull();
        return ArrayUtils.toPrimitive((Integer[])this.array);
    }

    @Override
    public long[] toLongArray() {
        if (this.isPrimitiveArray) {
            return (long[])this.array;
        }
        this.checkNoNull();
        return ArrayUtils.toPrimitive((Long[])this.array);
    }

    @Override
    public float[] toFloatArray() {
        if (this.isPrimitiveArray) {
            return (float[])this.array;
        }
        this.checkNoNull();
        return ArrayUtils.toPrimitive((Float[])this.array);
    }

    @Override
    public double[] toDoubleArray() {
        if (this.isPrimitiveArray) {
            return (double[])this.array;
        }
        this.checkNoNull();
        return ArrayUtils.toPrimitive((Double[])this.array);
    }
}

