/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data.serializer;

import java.io.IOException;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.serializer.SerializerSingleton;
import org.apache.paimon.io.DataInputView;
import org.apache.paimon.io.DataOutputView;
import org.apache.paimon.memory.MemorySegmentUtils;

public final class BinaryStringSerializer
extends SerializerSingleton<BinaryString> {
    private static final long serialVersionUID = 1L;
    public static final BinaryStringSerializer INSTANCE = new BinaryStringSerializer();

    private BinaryStringSerializer() {
    }

    @Override
    public BinaryString copy(BinaryString from) {
        return from.copy();
    }

    @Override
    public void serialize(BinaryString string, DataOutputView target) throws IOException {
        target.writeInt(string.getSizeInBytes());
        MemorySegmentUtils.copyToView(string.getSegments(), string.getOffset(), string.getSizeInBytes(), target);
    }

    @Override
    public BinaryString deserialize(DataInputView source) throws IOException {
        return BinaryStringSerializer.deserializeInternal(source);
    }

    public static BinaryString deserializeInternal(DataInputView source) throws IOException {
        int length = source.readInt();
        byte[] bytes = new byte[length];
        source.readFully(bytes);
        return BinaryString.fromBytes(bytes);
    }
}

