/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.disk;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.paimon.disk.BufferFileReader;
import org.apache.paimon.disk.BufferFileReaderImpl;
import org.apache.paimon.disk.BufferFileWriter;
import org.apache.paimon.disk.BufferFileWriterImpl;
import org.apache.paimon.disk.FileChannelManager;
import org.apache.paimon.disk.FileChannelManagerImpl;
import org.apache.paimon.disk.FileIOChannel;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOManagerImpl
implements IOManager {
    protected static final Logger LOG = LoggerFactory.getLogger(IOManager.class);
    private static final String DIR_NAME_PREFIX = "io";
    private final FileChannelManager fileChannelManager;

    public IOManagerImpl(String[] tempDirs) {
        this.fileChannelManager = new FileChannelManagerImpl(Preconditions.checkNotNull(tempDirs), DIR_NAME_PREFIX);
        if (LOG.isInfoEnabled()) {
            LOG.info("Created a new {} for spilling of task related data to disk (joins, sorting, ...). Used directories:\n\t{}", (Object)FileChannelManager.class.getSimpleName(), (Object)Arrays.stream(this.fileChannelManager.getPaths()).map(File::getAbsolutePath).collect(Collectors.joining("\n\t")));
        }
    }

    @Override
    public void close() throws Exception {
        this.fileChannelManager.close();
    }

    @Override
    public FileIOChannel.ID createChannel() {
        return this.fileChannelManager.createChannel();
    }

    @Override
    public FileIOChannel.Enumerator createChannelEnumerator() {
        return this.fileChannelManager.createChannelEnumerator();
    }

    public static void deleteChannel(FileIOChannel.ID channel) {
        if (channel != null && channel.getPathFile().exists() && !channel.getPathFile().delete()) {
            LOG.warn("IOManager failed to delete temporary file {}", (Object)channel.getPath());
        }
    }

    public File[] getSpillingDirectories() {
        return this.fileChannelManager.getPaths();
    }

    public String[] getSpillingDirectoriesPaths() {
        File[] paths = this.fileChannelManager.getPaths();
        String[] strings = new String[paths.length];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = paths[i].getAbsolutePath();
        }
        return strings;
    }

    @Override
    public BufferFileWriter createBufferFileWriter(FileIOChannel.ID channelID) throws IOException {
        return new BufferFileWriterImpl(channelID);
    }

    @Override
    public BufferFileReader createBufferFileReader(FileIOChannel.ID channelID) throws IOException {
        return new BufferFileReaderImpl(channelID);
    }
}

