/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format;

import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.InternalSerializers;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.format.FieldStats;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.RowDataToObjectArrayConverter;

public class FieldStatsCollector {
    private final Object[] minValues;
    private final Object[] maxValues;
    private final long[] nullCounts;
    private final RowDataToObjectArrayConverter converter;
    private final Serializer<Object>[] fieldSerializers;

    public FieldStatsCollector(RowType rowType) {
        int numFields = rowType.getFieldCount();
        this.minValues = new Object[numFields];
        this.maxValues = new Object[numFields];
        this.nullCounts = new long[numFields];
        this.converter = new RowDataToObjectArrayConverter(rowType);
        this.fieldSerializers = new Serializer[numFields];
        for (int i = 0; i < numFields; ++i) {
            this.fieldSerializers[i] = InternalSerializers.create(rowType.getTypeAt(i));
        }
    }

    public void collect(InternalRow row) {
        Object[] objects = this.converter.convert(row);
        for (int i = 0; i < row.getFieldCount(); ++i) {
            Object obj = objects[i];
            if (obj == null) {
                int n = i;
                this.nullCounts[n] = this.nullCounts[n] + 1L;
                continue;
            }
            if (!(obj instanceof Comparable)) continue;
            Comparable c = (Comparable)obj;
            if (this.minValues[i] == null || c.compareTo(this.minValues[i]) < 0) {
                this.minValues[i] = this.fieldSerializers[i].copy(c);
            }
            if (this.maxValues[i] != null && c.compareTo(this.maxValues[i]) <= 0) continue;
            this.maxValues[i] = this.fieldSerializers[i].copy(c);
        }
    }

    public FieldStats[] extract() {
        FieldStats[] stats = new FieldStats[this.nullCounts.length];
        for (int i = 0; i < stats.length; ++i) {
            stats[i] = new FieldStats(this.minValues[i], this.maxValues[i], this.nullCounts[i]);
        }
        return stats;
    }
}

