/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.format.FileFormatFactory;
import org.apache.paimon.format.FileStatsExtractor;
import org.apache.paimon.format.FormatReaderFactory;
import org.apache.paimon.format.FormatWriterFactory;
import org.apache.paimon.options.Options;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.types.RowType;

public abstract class FileFormat {
    protected String formatIdentifier;

    protected FileFormat(String formatIdentifier) {
        this.formatIdentifier = formatIdentifier;
    }

    public String getFormatIdentifier() {
        return this.formatIdentifier;
    }

    public abstract FormatReaderFactory createReaderFactory(RowType var1, int[][] var2, @Nullable List<Predicate> var3);

    public abstract FormatWriterFactory createWriterFactory(RowType var1);

    public abstract void validateDataFields(RowType var1);

    public FormatReaderFactory createReaderFactory(RowType rowType) {
        int[][] projection = new int[rowType.getFieldCount()][];
        for (int i = 0; i < projection.length; ++i) {
            projection[i] = new int[]{i};
        }
        return this.createReaderFactory(rowType, projection);
    }

    public FormatReaderFactory createReaderFactory(RowType rowType, int[][] projection) {
        return this.createReaderFactory(rowType, projection, new ArrayList<Predicate>());
    }

    public Optional<FileStatsExtractor> createStatsExtractor(RowType type) {
        return Optional.empty();
    }

    @VisibleForTesting
    public static FileFormat fromIdentifier(String identifier, Options options) {
        return FileFormat.fromIdentifier(identifier, new FileFormatFactory.FormatContext(options, 1024));
    }

    public static FileFormat fromIdentifier(String identifier, FileFormatFactory.FormatContext context) {
        Optional<FileFormat> format = FileFormat.fromIdentifier(identifier, context, Thread.currentThread().getContextClassLoader());
        return format.orElseGet(() -> FileFormat.fromIdentifier(identifier, context, FileFormat.class.getClassLoader()).orElseThrow(() -> new RuntimeException(String.format("Could not find any factories that implement '%s' in the classpath.", FileFormatFactory.class.getName()))));
    }

    private static Optional<FileFormat> fromIdentifier(String formatIdentifier, FileFormatFactory.FormatContext context, ClassLoader classLoader) {
        ServiceLoader<FileFormatFactory> serviceLoader = ServiceLoader.load(FileFormatFactory.class, classLoader);
        for (FileFormatFactory factory : serviceLoader) {
            if (!factory.identifier().equals(formatIdentifier.toLowerCase())) continue;
            return Optional.of(factory.create(context));
        }
        return Optional.empty();
    }
}

