/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.orc.writer;

import java.io.IOException;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FormatWriter;
import org.apache.paimon.format.orc.writer.Vectorizer;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.paimon.shade.org.apache.orc.Writer;
import org.apache.paimon.utils.Preconditions;

public class OrcBulkWriter
implements FormatWriter {
    private final Writer writer;
    private final Vectorizer<InternalRow> vectorizer;
    private final VectorizedRowBatch rowBatch;

    public OrcBulkWriter(Vectorizer<InternalRow> vectorizer, Writer writer) {
        this.vectorizer = Preconditions.checkNotNull(vectorizer);
        this.writer = Preconditions.checkNotNull(writer);
        this.rowBatch = vectorizer.getSchema().createRowBatch();
        this.vectorizer.setWriter(this.writer);
    }

    @Override
    public void addElement(InternalRow element) throws IOException {
        this.vectorizer.vectorize(element, this.rowBatch);
        if (this.rowBatch.size == this.rowBatch.getMaxSize()) {
            this.writer.addRowBatch(this.rowBatch);
            this.rowBatch.reset();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.rowBatch.size != 0) {
            this.writer.addRowBatch(this.rowBatch);
            this.rowBatch.reset();
        }
    }

    @Override
    public void finish() throws IOException {
        this.flush();
        this.writer.close();
    }
}

