/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.format.FieldStats;
import org.apache.paimon.format.FileStatsExtractor;
import org.apache.paimon.format.parquet.ParquetUtil;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.shade.org.apache.parquet.column.statistics.BinaryStatistics;
import org.apache.paimon.shade.org.apache.parquet.column.statistics.BooleanStatistics;
import org.apache.paimon.shade.org.apache.parquet.column.statistics.DoubleStatistics;
import org.apache.paimon.shade.org.apache.parquet.column.statistics.FloatStatistics;
import org.apache.paimon.shade.org.apache.parquet.column.statistics.IntStatistics;
import org.apache.paimon.shade.org.apache.parquet.column.statistics.LongStatistics;
import org.apache.paimon.shade.org.apache.parquet.column.statistics.Statistics;
import org.apache.paimon.shade.org.apache.parquet.schema.PrimitiveType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.TimestampType;

public class ParquetFileStatsExtractor
implements FileStatsExtractor {
    private final RowType rowType;
    private static final OffsetDateTime EPOCH = Instant.ofEpochSecond(0L).atOffset(ZoneOffset.UTC);
    private static final LocalDate EPOCH_DAY = EPOCH.toLocalDate();

    public ParquetFileStatsExtractor(RowType rowType) {
        this.rowType = rowType;
    }

    @Override
    public FieldStats[] extract(FileIO fileIO, Path path) throws IOException {
        Map<String, Statistics<?>> stats = ParquetUtil.extractColumnStats(fileIO, path);
        return (FieldStats[])IntStream.range(0, this.rowType.getFieldCount()).mapToObj(i -> {
            DataField field = this.rowType.getFields().get(i);
            return this.toFieldStats(field, (Statistics)stats.get(field.name()));
        }).toArray(FieldStats[]::new);
    }

    private FieldStats toFieldStats(DataField field, Statistics<?> stats) {
        if (stats == null) {
            return new FieldStats(null, null, null);
        }
        long nullCount = stats.getNumNulls();
        if (!stats.hasNonNullValue()) {
            return new FieldStats(null, null, nullCount);
        }
        switch (field.type().getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                ParquetUtil.assertStatsClass(field, stats, BinaryStatistics.class);
                BinaryStatistics stringStats = (BinaryStatistics)stats;
                return new FieldStats(BinaryString.fromString(stringStats.minAsString()), BinaryString.fromString(stringStats.maxAsString()), nullCount);
            }
            case BOOLEAN: {
                ParquetUtil.assertStatsClass(field, stats, BooleanStatistics.class);
                BooleanStatistics boolStats = (BooleanStatistics)stats;
                return new FieldStats(boolStats.getMin(), boolStats.getMax(), nullCount);
            }
            case DECIMAL: {
                PrimitiveType primitive = stats.type();
                DecimalType decimalType = (DecimalType)field.type();
                int precision = decimalType.getPrecision();
                int scale = decimalType.getScale();
                return this.convertStatsToDecimalFieldStats(primitive, field, stats, precision, scale, nullCount);
            }
            case TINYINT: {
                ParquetUtil.assertStatsClass(field, stats, IntStatistics.class);
                IntStatistics byteStats = (IntStatistics)stats;
                return new FieldStats((byte)byteStats.getMin(), (byte)byteStats.getMax(), nullCount);
            }
            case SMALLINT: {
                ParquetUtil.assertStatsClass(field, stats, IntStatistics.class);
                IntStatistics shortStats = (IntStatistics)stats;
                return new FieldStats((short)shortStats.getMin(), (short)shortStats.getMax(), nullCount);
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: {
                ParquetUtil.assertStatsClass(field, stats, IntStatistics.class);
                IntStatistics intStats = (IntStatistics)stats;
                return new FieldStats(Long.valueOf(intStats.getMin()).intValue(), Long.valueOf(intStats.getMax()).intValue(), nullCount);
            }
            case BIGINT: {
                ParquetUtil.assertStatsClass(field, stats, LongStatistics.class);
                LongStatistics longStats = (LongStatistics)stats;
                return new FieldStats(longStats.getMin(), longStats.getMax(), nullCount);
            }
            case FLOAT: {
                ParquetUtil.assertStatsClass(field, stats, FloatStatistics.class);
                FloatStatistics floatStats = (FloatStatistics)stats;
                return new FieldStats(Float.valueOf(floatStats.getMin()), Float.valueOf(floatStats.getMax()), nullCount);
            }
            case DOUBLE: {
                ParquetUtil.assertStatsClass(field, stats, DoubleStatistics.class);
                DoubleStatistics doubleStats = (DoubleStatistics)stats;
                return new FieldStats(doubleStats.getMin(), doubleStats.getMax(), nullCount);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return this.toTimestampStats(stats, ((TimestampType)field.type()).getPrecision());
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return this.toTimestampStats(stats, ((LocalZonedTimestampType)field.type()).getPrecision());
            }
        }
        return new FieldStats(null, null, nullCount);
    }

    private FieldStats toTimestampStats(Statistics<?> stats, int precision) {
        if (precision <= 3) {
            LongStatistics longStats = (LongStatistics)stats;
            return new FieldStats(Timestamp.fromEpochMillis(longStats.getMin()), Timestamp.fromEpochMillis(longStats.getMax()), stats.getNumNulls());
        }
        if (precision <= 6) {
            LongStatistics longStats = (LongStatistics)stats;
            return new FieldStats(Timestamp.fromMicros(longStats.getMin()), Timestamp.fromMicros(longStats.getMax()), stats.getNumNulls());
        }
        return new FieldStats(null, null, stats.getNumNulls());
    }

    private FieldStats convertStatsToDecimalFieldStats(PrimitiveType primitive, DataField field, Statistics<?> stats, int precision, int scale, long nullCount) {
        switch (primitive.getPrimitiveTypeName()) {
            case BINARY: 
            case FIXED_LEN_BYTE_ARRAY: {
                ParquetUtil.assertStatsClass(field, stats, BinaryStatistics.class);
                BinaryStatistics decimalStats = (BinaryStatistics)stats;
                return new FieldStats(Decimal.fromBigDecimal(new BigDecimal(new BigInteger(decimalStats.getMinBytes()), scale), precision, scale), Decimal.fromBigDecimal(new BigDecimal(new BigInteger(decimalStats.getMaxBytes()), scale), precision, scale), nullCount);
            }
            case INT64: {
                ParquetUtil.assertStatsClass(field, stats, LongStatistics.class);
                LongStatistics longStats = (LongStatistics)stats;
                return new FieldStats(Decimal.fromUnscaledLong(longStats.getMin(), precision, scale), Decimal.fromUnscaledLong(longStats.getMax(), precision, scale), nullCount);
            }
            case INT32: {
                ParquetUtil.assertStatsClass(field, stats, IntStatistics.class);
                IntStatistics intStats = (IntStatistics)stats;
                return new FieldStats(Decimal.fromUnscaledLong(intStats.getMin(), precision, scale), Decimal.fromUnscaledLong(intStats.getMax(), precision, scale), nullCount);
            }
        }
        return new FieldStats(null, null, nullCount);
    }
}

