/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.paimon.format.parquet.ParquetInputFile;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.shade.org.apache.parquet.ParquetReadOptions;
import org.apache.paimon.shade.org.apache.parquet.column.statistics.Statistics;
import org.apache.paimon.shade.org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.paimon.shade.org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.paimon.shade.org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.paimon.shade.org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.paimon.types.DataField;

public class ParquetUtil {
    public static Map<String, Statistics<?>> extractColumnStats(FileIO fileIO, Path path) throws IOException {
        ParquetMetadata parquetMetadata = ParquetUtil.getParquetReader(fileIO, path).getFooter();
        List<BlockMetaData> blockMetaDataList = parquetMetadata.getBlocks();
        HashMap resultStats = new HashMap();
        for (BlockMetaData blockMetaData : blockMetaDataList) {
            List<ColumnChunkMetaData> columnChunkMetaDataList = blockMetaData.getColumns();
            for (ColumnChunkMetaData columnChunkMetaData : columnChunkMetaDataList) {
                Statistics midStats;
                Statistics stats = columnChunkMetaData.getStatistics();
                String columnName = columnChunkMetaData.getPath().toDotString();
                if (!resultStats.containsKey(columnName)) {
                    midStats = stats;
                } else {
                    midStats = (Statistics)resultStats.get(columnName);
                    midStats.mergeStatistics(stats);
                }
                resultStats.put(columnName, midStats);
            }
        }
        return resultStats;
    }

    public static ParquetFileReader getParquetReader(FileIO fileIO, Path path) throws IOException {
        return ParquetFileReader.open(ParquetInputFile.fromPath(fileIO, path), ParquetReadOptions.builder().build());
    }

    static void assertStatsClass(DataField field, Statistics<?> stats, Class<? extends Statistics<?>> expectedClass) {
        if (!expectedClass.isInstance(stats)) {
            throw new IllegalArgumentException("Expecting " + expectedClass.getName() + " for field " + field.asSQLString() + " but found " + stats.getClass().getName());
        }
    }
}

