/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.writer;

import java.io.IOException;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.parquet.writer.ParquetBuilder;
import org.apache.paimon.format.parquet.writer.ParquetRowDataBuilder;
import org.apache.paimon.options.Options;
import org.apache.paimon.shade.org.apache.parquet.column.ParquetProperties;
import org.apache.paimon.shade.org.apache.parquet.hadoop.ParquetWriter;
import org.apache.paimon.shade.org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.paimon.shade.org.apache.parquet.io.OutputFile;
import org.apache.paimon.types.RowType;

public class RowDataParquetBuilder
implements ParquetBuilder<InternalRow> {
    private final RowType rowType;
    private final Options conf;

    public RowDataParquetBuilder(RowType rowType, Options conf) {
        this.rowType = rowType;
        this.conf = conf;
    }

    @Override
    public ParquetWriter<InternalRow> createWriter(OutputFile out, String compression) throws IOException {
        String compressName = CompressionCodecName.SNAPPY.name();
        if (null != compression) {
            compressName = compression;
        }
        return ((ParquetRowDataBuilder)((ParquetRowDataBuilder)((ParquetRowDataBuilder)((ParquetRowDataBuilder)((ParquetRowDataBuilder)((ParquetRowDataBuilder)((ParquetRowDataBuilder)((ParquetRowDataBuilder)new ParquetRowDataBuilder(out, this.rowType).withCompressionCodec(CompressionCodecName.fromConf(this.conf.getString("parquet.compression", compressName)))).withRowGroupSize(this.conf.getLong("parquet.block.size", 0x8000000L))).withPageSize(this.conf.getInteger("parquet.page.size", 0x100000))).withDictionaryPageSize(this.conf.getInteger("parquet.dictionary.page.size", 0x100000))).withMaxPaddingSize(this.conf.getInteger("parquet.writer.max-padding", 0x800000))).withDictionaryEncoding(this.conf.getBoolean("parquet.enable.dictionary", true))).withValidation(this.conf.getBoolean("parquet.validation", false))).withWriterVersion(ParquetProperties.WriterVersion.fromString(this.conf.getString("parquet.writer.version", ParquetProperties.DEFAULT_WRITER_VERSION.toString())))).build();
    }
}

