/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.fs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.UUID;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.fs.FileIOLoader;
import org.apache.paimon.fs.FileIOUtils;
import org.apache.paimon.fs.FileStatus;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.PositionOutputStream;
import org.apache.paimon.fs.SeekableInputStream;
import org.apache.paimon.fs.UnsupportedSchemeException;
import org.apache.paimon.fs.hadoop.HadoopFileIOLoader;
import org.apache.paimon.fs.local.LocalFileIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Public
public interface FileIO
extends Serializable {
    public static final Logger LOG = LoggerFactory.getLogger(FileIO.class);

    public boolean isObjectStore();

    public void configure(CatalogContext var1);

    public SeekableInputStream newInputStream(Path var1) throws IOException;

    public PositionOutputStream newOutputStream(Path var1, boolean var2) throws IOException;

    public FileStatus getFileStatus(Path var1) throws IOException;

    public FileStatus[] listStatus(Path var1) throws IOException;

    public boolean exists(Path var1) throws IOException;

    public boolean delete(Path var1, boolean var2) throws IOException;

    public boolean mkdirs(Path var1) throws IOException;

    public boolean rename(Path var1, Path var2) throws IOException;

    default public void deleteQuietly(Path file) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ready to delete " + file.toString());
        }
        try {
            if (!this.delete(file, false) && this.exists(file)) {
                LOG.warn("Failed to delete file " + file);
            }
        }
        catch (IOException e) {
            LOG.warn("Exception occurs when deleting file " + file, (Throwable)e);
        }
    }

    default public void deleteDirectoryQuietly(Path directory) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ready to delete " + directory.toString());
        }
        try {
            if (!this.delete(directory, true) && this.exists(directory)) {
                LOG.warn("Failed to delete directory " + directory);
            }
        }
        catch (IOException e) {
            LOG.warn("Exception occurs when deleting directory " + directory, (Throwable)e);
        }
    }

    default public long getFileSize(Path path) throws IOException {
        return this.getFileStatus(path).getLen();
    }

    default public boolean isDir(Path path) throws IOException {
        return this.getFileStatus(path).isDir();
    }

    default public String readFileUtf8(Path path) throws IOException {
        try (SeekableInputStream in = this.newInputStream(path);){
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, StandardCharsets.UTF_8));
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            String string = builder.toString();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public boolean writeFileUtf8(Path path, String content) throws IOException {
        if (this.exists(path)) {
            return false;
        }
        Path tmp = new Path(path.getParent(), "." + path.getName() + UUID.randomUUID());
        boolean success = false;
        try {
            try (PositionOutputStream out = this.newOutputStream(tmp, false);){
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
                writer.write(content);
                writer.flush();
            }
            success = this.rename(tmp, path);
        }
        finally {
            if (!success) {
                this.deleteQuietly(tmp);
            }
        }
        return success;
    }

    public static FileIO get(Path path, CatalogContext config) throws IOException {
        URI uri = path.toUri();
        if (uri.getScheme() == null) {
            return new LocalFileIO();
        }
        if (uri.getScheme().equals("file") && uri.getAuthority() != null && !uri.getAuthority().isEmpty()) {
            String supposedUri = "file:///" + uri.getAuthority() + uri.getPath();
            throw new IOException("Found local file path with authority '" + uri.getAuthority() + "' in path '" + uri + "'. Hint: Did you forget a slash? (correct path would be '" + supposedUri + "')");
        }
        Map<String, FileIOLoader> loaders = FileIO.discoverLoaders();
        FileIOLoader loader = loaders.get(uri.getScheme());
        FileIOLoader fallbackIO = config.fallbackIO();
        if (loader == null) {
            loader = FileIOUtils.checkAccess(fallbackIO, path, config);
        }
        if (loader == null) {
            loader = FileIOUtils.checkAccess(new HadoopFileIOLoader(), path, config);
        }
        if (loader == null) {
            String fallbackMsg = "";
            if (fallbackIO != null) {
                fallbackMsg = " " + fallbackIO.getClass().getSimpleName() + " also cannot access this path.";
            }
            throw new UnsupportedSchemeException(String.format("Could not find a file io implementation for scheme '%s' in the classpath.%s Hadoop FileSystem also cannot access this path '%s'.", uri.getScheme(), fallbackMsg, path));
        }
        FileIO fileIO = loader.load(path);
        fileIO.configure(config);
        return fileIO;
    }

    public static Map<String, FileIOLoader> discoverLoaders() {
        HashMap<String, FileIOLoader> results = new HashMap<String, FileIOLoader>();
        Iterator<FileIOLoader> iterator = ServiceLoader.load(FileIOLoader.class, FileIOLoader.class.getClassLoader()).iterator();
        iterator.forEachRemaining(fileIO -> {
            FileIOLoader previous = results.put(fileIO.getScheme(), (FileIOLoader)fileIO);
            if (previous != null) {
                throw new RuntimeException(String.format("Multiple FileIO for scheme '%s' found in the classpath.\nAmbiguous FileIO classes are:\n%s\n%s", fileIO.getScheme(), previous.getClass().getName(), fileIO.getClass().getName()));
            }
        });
        return results;
    }
}

