/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.fs.hadoop;

import java.io.IOException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.FileStatus;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.PositionOutputStream;
import org.apache.paimon.fs.SeekableInputStream;
import org.apache.paimon.hadoop.SerializableConfiguration;

public class HadoopFileIO
implements FileIO {
    private static final long serialVersionUID = 1L;
    protected SerializableConfiguration hadoopConf;
    protected volatile transient FileSystem fs;

    @VisibleForTesting
    public void setFileSystem(FileSystem fs) {
        this.fs = fs;
    }

    @Override
    public boolean isObjectStore() {
        return false;
    }

    @Override
    public void configure(CatalogContext context) {
        this.hadoopConf = new SerializableConfiguration(context.hadoopConf());
    }

    @Override
    public SeekableInputStream newInputStream(Path path) throws IOException {
        org.apache.hadoop.fs.Path hadoopPath = this.path(path);
        return new HadoopSeekableInputStream(this.getFileSystem(hadoopPath).open(hadoopPath));
    }

    @Override
    public PositionOutputStream newOutputStream(Path path, boolean overwrite) throws IOException {
        org.apache.hadoop.fs.Path hadoopPath = this.path(path);
        return new HadoopPositionOutputStream(this.getFileSystem(hadoopPath).create(hadoopPath, overwrite));
    }

    @Override
    public FileStatus getFileStatus(Path path) throws IOException {
        org.apache.hadoop.fs.Path hadoopPath = this.path(path);
        return new HadoopFileStatus(this.getFileSystem(hadoopPath).getFileStatus(hadoopPath));
    }

    @Override
    public FileStatus[] listStatus(Path path) throws IOException {
        org.apache.hadoop.fs.Path hadoopPath = this.path(path);
        FileStatus[] statuses = new FileStatus[]{};
        org.apache.hadoop.fs.FileStatus[] hadoopStatuses = this.getFileSystem(hadoopPath).listStatus(hadoopPath);
        if (hadoopStatuses != null) {
            statuses = new FileStatus[hadoopStatuses.length];
            for (int i = 0; i < hadoopStatuses.length; ++i) {
                statuses[i] = new HadoopFileStatus(hadoopStatuses[i]);
            }
        }
        return statuses;
    }

    @Override
    public boolean exists(Path path) throws IOException {
        org.apache.hadoop.fs.Path hadoopPath = this.path(path);
        return this.getFileSystem(hadoopPath).exists(hadoopPath);
    }

    @Override
    public boolean delete(Path path, boolean recursive) throws IOException {
        org.apache.hadoop.fs.Path hadoopPath = this.path(path);
        return this.getFileSystem(hadoopPath).delete(hadoopPath, recursive);
    }

    @Override
    public boolean mkdirs(Path path) throws IOException {
        org.apache.hadoop.fs.Path hadoopPath = this.path(path);
        return this.getFileSystem(hadoopPath).mkdirs(hadoopPath);
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        org.apache.hadoop.fs.Path hadoopSrc = this.path(src);
        org.apache.hadoop.fs.Path hadoopDst = this.path(dst);
        return this.getFileSystem(hadoopSrc).rename(hadoopSrc, hadoopDst);
    }

    private org.apache.hadoop.fs.Path path(Path path) {
        return new org.apache.hadoop.fs.Path(path.toUri());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileSystem getFileSystem(org.apache.hadoop.fs.Path path) throws IOException {
        if (this.fs == null) {
            HadoopFileIO hadoopFileIO = this;
            synchronized (hadoopFileIO) {
                if (this.fs == null) {
                    this.fs = this.createFileSystem(path);
                }
            }
        }
        return this.fs;
    }

    protected FileSystem createFileSystem(org.apache.hadoop.fs.Path path) throws IOException {
        return path.getFileSystem(this.hadoopConf.get());
    }

    private static class HadoopFileStatus
    implements FileStatus {
        private final org.apache.hadoop.fs.FileStatus status;

        private HadoopFileStatus(org.apache.hadoop.fs.FileStatus status) {
            this.status = status;
        }

        @Override
        public long getLen() {
            return this.status.getLen();
        }

        @Override
        public boolean isDir() {
            return this.status.isDirectory();
        }

        @Override
        public Path getPath() {
            return new Path(this.status.getPath().toUri());
        }
    }

    private static class HadoopPositionOutputStream
    extends PositionOutputStream {
        private final FSDataOutputStream out;

        private HadoopPositionOutputStream(FSDataOutputStream out) {
            this.out = out;
        }

        @Override
        public long getPos() throws IOException {
            return this.out.getPos();
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.out.hflush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }

    private static class HadoopSeekableInputStream
    extends SeekableInputStream {
        private static final int MIN_SKIP_BYTES = 0x100000;
        private final FSDataInputStream in;

        private HadoopSeekableInputStream(FSDataInputStream in) {
            this.in = in;
        }

        @Override
        public void seek(long seekPos) throws IOException {
            long delta = seekPos - this.getPos();
            if (delta > 0L && delta <= 0x100000L) {
                this.skipFully(delta);
            } else if (delta != 0L) {
                this.forceSeek(seekPos);
            }
        }

        @Override
        public long getPos() throws IOException {
            return this.in.getPos();
        }

        @Override
        public int read() throws IOException {
            return this.in.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.in.read(b, off, len);
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        public void forceSeek(long seekPos) throws IOException {
            this.in.seek(seekPos);
        }

        public void skipFully(long bytes) throws IOException {
            while (bytes > 0L) {
                bytes -= this.in.skip(bytes);
            }
        }
    }
}

