/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.fs.local;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.FileStatus;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.PositionOutputStream;
import org.apache.paimon.fs.SeekableInputStream;
import org.apache.paimon.utils.Preconditions;

public class LocalFileIO
implements FileIO {
    private static final long serialVersionUID = 1L;
    private static final ReentrantLock RENAME_LOCK = new ReentrantLock();

    public static LocalFileIO create() {
        return new LocalFileIO();
    }

    @Override
    public boolean isObjectStore() {
        return false;
    }

    @Override
    public void configure(CatalogContext context) {
    }

    @Override
    public SeekableInputStream newInputStream(Path path) throws IOException {
        return new LocalSeekableInputStream(this.toFile(path));
    }

    @Override
    public PositionOutputStream newOutputStream(Path path, boolean overwrite) throws IOException {
        if (this.exists(path) && !overwrite) {
            throw new FileAlreadyExistsException("File already exists: " + path);
        }
        Path parent = path.getParent();
        if (parent != null && !this.mkdirs(parent)) {
            throw new IOException("Mkdirs failed to create " + parent);
        }
        return new LocalPositionOutputStream(this.toFile(path));
    }

    @Override
    public FileStatus getFileStatus(Path path) throws IOException {
        File file = this.toFile(path);
        if (file.exists()) {
            return new LocalFileStatus(file, "file");
        }
        throw new FileNotFoundException("File " + file + " does not exist or the user running Paimon ('" + System.getProperty("user.name") + "') has insufficient permissions to access it.");
    }

    @Override
    public FileStatus[] listStatus(Path path) throws IOException {
        File file = this.toFile(path);
        FileStatus[] results = new FileStatus[]{};
        if (!file.exists()) {
            return results;
        }
        if (file.isFile()) {
            results = new FileStatus[]{new LocalFileStatus(file, "file")};
        } else {
            String[] names = file.list();
            if (names != null) {
                ArrayList<FileStatus> fileList = new ArrayList<FileStatus>(names.length);
                for (String name : names) {
                    try {
                        fileList.add(this.getFileStatus(new Path(path, name)));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
                results = fileList.toArray(new FileStatus[0]);
            }
        }
        return results;
    }

    @Override
    public boolean exists(Path path) throws IOException {
        return this.toFile(path).exists();
    }

    @Override
    public boolean delete(Path path, boolean recursive) throws IOException {
        File file = this.toFile(path);
        if (file.isFile()) {
            return file.delete();
        }
        if (!recursive && file.isDirectory()) {
            File[] containedFiles = file.listFiles();
            if (containedFiles == null) {
                throw new IOException("Directory " + file + " does not exist or an I/O error occurred");
            }
            if (containedFiles.length != 0) {
                throw new IOException("Directory " + file + " is not empty");
            }
        }
        return this.delete(file);
    }

    private boolean delete(File f) {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            if (files != null) {
                for (File file : files) {
                    boolean del = this.delete(file);
                    if (del) continue;
                    return false;
                }
            }
        } else {
            return f.delete();
        }
        return f.delete();
    }

    @Override
    public boolean mkdirs(Path path) throws IOException {
        return this.mkdirsInternal(this.toFile(path));
    }

    private boolean mkdirsInternal(File file) throws IOException {
        if (file.isDirectory()) {
            return true;
        }
        if (file.exists() && !file.isDirectory()) {
            throw new FileAlreadyExistsException(file.getAbsolutePath());
        }
        File parent = file.getParentFile();
        return !(parent != null && !this.mkdirsInternal(parent) || !file.mkdir() && !file.isDirectory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        File srcFile = this.toFile(src);
        File dstFile = this.toFile(dst);
        File dstParent = dstFile.getParentFile();
        dstParent.mkdirs();
        try {
            RENAME_LOCK.lock();
            if (dstFile.exists()) {
                boolean bl = false;
                return bl;
            }
            Files.move(srcFile.toPath(), dstFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
            boolean bl = true;
            return bl;
        }
        catch (SecurityException | AccessDeniedException | DirectoryNotEmptyException | NoSuchFileException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            RENAME_LOCK.unlock();
        }
    }

    public File toFile(Path path) {
        String localPath = path.getPath();
        Preconditions.checkState(localPath != null, "Cannot convert a null path to File");
        if (localPath.length() == 0) {
            return new File(".");
        }
        return new File(localPath);
    }

    private static class LocalFileStatus
    implements FileStatus {
        private final File file;
        private final long length;
        private final String scheme;

        private LocalFileStatus(File file, String scheme) {
            this.file = file;
            this.length = file.length();
            this.scheme = scheme;
        }

        @Override
        public long getLen() {
            return this.length;
        }

        @Override
        public boolean isDir() {
            return this.file.isDirectory();
        }

        @Override
        public Path getPath() {
            return new Path(this.scheme + ":" + this.file.toURI().getPath());
        }
    }

    public static class LocalPositionOutputStream
    extends PositionOutputStream {
        private final FileOutputStream out;

        public LocalPositionOutputStream(File file) throws FileNotFoundException {
            this.out = new FileOutputStream(file);
        }

        @Override
        public long getPos() throws IOException {
            return this.out.getChannel().position();
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }

    public static class LocalSeekableInputStream
    extends SeekableInputStream {
        private final FileInputStream in;
        private final FileChannel channel;

        public LocalSeekableInputStream(File file) throws FileNotFoundException {
            this.in = new FileInputStream(file);
            this.channel = this.in.getChannel();
        }

        @Override
        public void seek(long desired) throws IOException {
            if (desired != this.getPos()) {
                this.channel.position(desired);
            }
        }

        @Override
        public long getPos() throws IOException {
            return this.channel.position();
        }

        @Override
        public int read() throws IOException {
            return this.in.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.in.read(b, off, len);
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }
    }
}

