/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.table.hive.LegacyHiveClasses;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.RetryingMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.paimon.catalog.AbstractCatalog;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogLock;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.hive.HiveCatalogLock;
import org.apache.paimon.hive.HiveTypeUtils;
import org.apache.paimon.operation.Lock;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.OptionsUtils;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.TableType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.StringUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveCatalog
extends AbstractCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(HiveCatalog.class);
    private static final String INPUT_FORMAT_CLASS_NAME = "org.apache.paimon.hive.mapred.PaimonInputFormat";
    private static final String OUTPUT_FORMAT_CLASS_NAME = "org.apache.paimon.hive.mapred.PaimonOutputFormat";
    private static final String SERDE_CLASS_NAME = "org.apache.paimon.hive.PaimonSerDe";
    private static final String STORAGE_HANDLER_CLASS_NAME = "org.apache.paimon.hive.PaimonStorageHandler";
    public static final String HIVE_SITE_FILE = "hive-site.xml";
    private final HiveConf hiveConf;
    private final String clientClassName;
    private final IMetaStoreClient client;
    private static final List<Class<?>[]> GET_PROXY_PARAMS = Arrays.asList({HiveConf.class, HiveMetaHookLoader.class, ConcurrentHashMap.class, String.class, Boolean.TYPE}, {Configuration.class, HiveMetaHookLoader.class, ConcurrentHashMap.class, String.class, Boolean.TYPE});

    public HiveCatalog(FileIO fileIO, HiveConf hiveConf, String clientClassName) {
        super(fileIO);
        this.hiveConf = hiveConf;
        this.clientClassName = clientClassName;
        this.client = HiveCatalog.createClient(hiveConf, clientClassName);
    }

    public HiveCatalog(FileIO fileIO, HiveConf hiveConf, String clientClassName, Map<String, String> options) {
        super(fileIO, options);
        this.hiveConf = hiveConf;
        this.clientClassName = clientClassName;
        this.client = HiveCatalog.createClient(hiveConf, clientClassName);
    }

    @Override
    public Optional<CatalogLock.Factory> lockFactory() {
        return this.lockEnabled() ? Optional.of(HiveCatalogLock.createFactory(this.hiveConf, this.clientClassName)) : Optional.empty();
    }

    private boolean lockEnabled() {
        return Boolean.parseBoolean(this.hiveConf.get(CatalogOptions.LOCK_ENABLED.key(), CatalogOptions.LOCK_ENABLED.defaultValue().toString()));
    }

    @Override
    public List<String> listDatabases() {
        try {
            return this.client.getAllDatabases();
        }
        catch (TException e) {
            throw new RuntimeException("Failed to list all databases", e);
        }
    }

    @Override
    public boolean databaseExists(String databaseName) {
        try {
            this.client.getDatabase(databaseName);
            return true;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        catch (TException e) {
            throw new RuntimeException("Failed to determine if database " + databaseName + " exists", e);
        }
    }

    @Override
    public void createDatabase(String name, boolean ignoreIfExists) throws Catalog.DatabaseAlreadyExistException {
        try {
            this.client.createDatabase(this.convertToDatabase(name));
        }
        catch (AlreadyExistsException e) {
            if (!ignoreIfExists) {
                throw new Catalog.DatabaseAlreadyExistException(name, e);
            }
        }
        catch (TException e) {
            throw new RuntimeException("Failed to create database " + name, e);
        }
    }

    @Override
    public void dropDatabase(String name, boolean ignoreIfNotExists, boolean cascade) throws Catalog.DatabaseNotExistException, Catalog.DatabaseNotEmptyException {
        try {
            if (!cascade && this.client.getAllTables(name).size() > 0) {
                throw new Catalog.DatabaseNotEmptyException(name);
            }
            this.client.dropDatabase(name, true, false, true);
        }
        catch (NoSuchObjectException | UnknownDBException e) {
            if (!ignoreIfNotExists) {
                throw new Catalog.DatabaseNotExistException(name, e);
            }
        }
        catch (TException e) {
            throw new RuntimeException("Failed to drop database " + name, e);
        }
    }

    @Override
    public List<String> listTables(String databaseName) throws Catalog.DatabaseNotExistException {
        try {
            return this.client.getAllTables(databaseName).stream().filter(tableName -> {
                Identifier identifier = new Identifier(databaseName, (String)tableName);
                return this.schemaFileExists(identifier) && this.paimonTableExists(identifier, false);
            }).collect(Collectors.toList());
        }
        catch (UnknownDBException e) {
            throw new Catalog.DatabaseNotExistException(databaseName, e);
        }
        catch (TException e) {
            throw new RuntimeException("Failed to list all tables in database " + databaseName, e);
        }
    }

    @Override
    public TableSchema getDataTableSchema(Identifier identifier) throws Catalog.TableNotExistException {
        if (!this.paimonTableExists(identifier)) {
            throw new Catalog.TableNotExistException(identifier);
        }
        Path tableLocation = this.getDataTableLocation(identifier);
        return new SchemaManager(this.fileIO, tableLocation).latest().orElseThrow(() -> new RuntimeException("There is no paimond in " + tableLocation));
    }

    @Override
    public void dropTable(Identifier identifier, boolean ignoreIfNotExists) throws Catalog.TableNotExistException {
        this.checkNotSystemTable(identifier, "dropTable");
        if (!this.paimonTableExists(identifier)) {
            if (ignoreIfNotExists) {
                return;
            }
            throw new Catalog.TableNotExistException(identifier);
        }
        try {
            this.client.dropTable(identifier.getDatabaseName(), identifier.getObjectName(), true, false, true);
            Path path = this.getDataTableLocation(identifier);
            try {
                if (this.fileIO.exists(path)) {
                    this.fileIO.deleteDirectoryQuietly(path);
                }
            }
            catch (Exception ee) {
                LOG.error("Delete directory[{}] fail for table {}", new Object[]{path, identifier, ee});
            }
        }
        catch (TException e) {
            throw new RuntimeException("Failed to drop table " + identifier.getFullName(), e);
        }
    }

    @Override
    public void createTable(Identifier identifier, Schema schema, boolean ignoreIfExists) throws Catalog.TableAlreadyExistException, Catalog.DatabaseNotExistException {
        TableSchema tableSchema;
        this.checkNotSystemTable(identifier, "createTable");
        String databaseName = identifier.getDatabaseName();
        if (!this.databaseExists(databaseName)) {
            throw new Catalog.DatabaseNotExistException(databaseName);
        }
        if (this.paimonTableExists(identifier)) {
            if (ignoreIfExists) {
                return;
            }
            throw new Catalog.TableAlreadyExistException(identifier);
        }
        this.checkFieldNamesUpperCase(schema.rowType().getFieldNames());
        this.copyTableDefaultOptions(schema.options());
        try {
            tableSchema = this.schemaManager(identifier).createTable(schema);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to commit changes of table " + identifier.getFullName() + " to underlying files", e);
        }
        Table table = this.newHmsTable(identifier);
        this.updateHmsTable(table, identifier, tableSchema);
        try {
            this.client.createTable(table);
        }
        catch (TException e) {
            Path path = this.getDataTableLocation(identifier);
            try {
                this.fileIO.deleteDirectoryQuietly(path);
            }
            catch (Exception ee) {
                LOG.error("Delete directory[{}] fail for table {}", new Object[]{path, identifier, ee});
            }
            throw new RuntimeException("Failed to create table " + identifier.getFullName(), e);
        }
    }

    @Override
    public void renameTable(Identifier fromTable, Identifier toTable, boolean ignoreIfNotExists) throws Catalog.TableNotExistException, Catalog.TableAlreadyExistException {
        this.checkNotSystemTable(fromTable, "renameTable");
        this.checkNotSystemTable(toTable, "renameTable");
        if (!this.paimonTableExists(fromTable)) {
            if (ignoreIfNotExists) {
                return;
            }
            throw new Catalog.TableNotExistException(fromTable);
        }
        if (this.paimonTableExists(toTable)) {
            throw new Catalog.TableAlreadyExistException(toTable);
        }
        try {
            this.checkIdentifierUpperCase(toTable);
            String fromDB = fromTable.getDatabaseName();
            String fromTableName = fromTable.getObjectName();
            Table table = this.client.getTable(fromDB, fromTableName);
            table.setDbName(toTable.getDatabaseName());
            table.setTableName(toTable.getObjectName());
            this.client.alter_table(fromDB, fromTableName, table);
        }
        catch (TException e) {
            throw new RuntimeException("Failed to rename table " + fromTable.getFullName(), e);
        }
    }

    @Override
    public void alterTable(Identifier identifier, List<SchemaChange> changes, boolean ignoreIfNotExists) throws Catalog.TableNotExistException {
        this.checkNotSystemTable(identifier, "alterTable");
        if (!this.paimonTableExists(identifier)) {
            if (ignoreIfNotExists) {
                return;
            }
            throw new Catalog.TableNotExistException(identifier);
        }
        this.checkFieldNamesUpperCaseInSchemaChange(changes);
        try {
            SchemaManager schemaManager = this.schemaManager(identifier);
            TableSchema schema = schemaManager.commitChanges(changes);
            try {
                Table table = this.client.getTable(identifier.getDatabaseName(), identifier.getObjectName());
                this.updateHmsTable(table, identifier, schema);
                this.client.alter_table(identifier.getDatabaseName(), identifier.getObjectName(), table);
            }
            catch (TException te) {
                schemaManager.deleteSchema(schema.id());
                throw te;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean caseSensitive() {
        return false;
    }

    @Override
    public void close() throws Exception {
        this.client.close();
    }

    @Override
    protected String warehouse() {
        return this.hiveConf.get(HiveConf.ConfVars.METASTOREWAREHOUSE.varname);
    }

    private void checkIdentifierUpperCase(Identifier identifier) {
        Preconditions.checkState(identifier.getDatabaseName().equals(identifier.getDatabaseName().toLowerCase()), String.format("Database name[%s] cannot contain upper case in hive catalog", identifier.getDatabaseName()));
        Preconditions.checkState(identifier.getObjectName().equals(identifier.getObjectName().toLowerCase()), String.format("Table name[%s] cannot contain upper case in hive catalog", identifier.getObjectName()));
    }

    private void checkFieldNamesUpperCaseInSchemaChange(List<SchemaChange> changes) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (SchemaChange change : changes) {
            if (change instanceof SchemaChange.AddColumn) {
                SchemaChange.AddColumn addColumn = (SchemaChange.AddColumn)change;
                fieldNames.add(addColumn.fieldName());
                continue;
            }
            if (!(change instanceof SchemaChange.RenameColumn)) continue;
            SchemaChange.RenameColumn rename = (SchemaChange.RenameColumn)change;
            fieldNames.add(rename.newName());
        }
        this.checkFieldNamesUpperCase(fieldNames);
    }

    private void checkFieldNamesUpperCase(List<String> fieldNames) {
        List illegalFieldNames = fieldNames.stream().filter(f -> !f.equals(f.toLowerCase())).collect(Collectors.toList());
        Preconditions.checkState(illegalFieldNames.isEmpty(), String.format("Field names %s cannot contain upper case in hive catalog", illegalFieldNames));
    }

    private Database convertToDatabase(String name) {
        Database database = new Database();
        database.setName(name);
        database.setLocationUri(this.databasePath(name).toString());
        return database;
    }

    private Table newHmsTable(Identifier identifier) {
        long currentTimeMillis = System.currentTimeMillis();
        TableType tableType = OptionsUtils.convertToEnum(this.hiveConf.get(CatalogOptions.TABLE_TYPE.key(), TableType.MANAGED.toString()), TableType.class);
        Table table = new Table(identifier.getObjectName(), identifier.getDatabaseName(), System.getProperty("user.name"), (int)(currentTimeMillis / 1000L), (int)(currentTimeMillis / 1000L), Integer.MAX_VALUE, null, Collections.emptyList(), new HashMap(), null, null, tableType.toString().toUpperCase(Locale.ROOT) + "_TABLE");
        table.getParameters().put("storage_handler", STORAGE_HANDLER_CLASS_NAME);
        if (TableType.EXTERNAL.equals(tableType)) {
            table.getParameters().put("EXTERNAL", "TRUE");
        }
        return table;
    }

    private void updateHmsTable(Table table, Identifier identifier, TableSchema schema) {
        StorageDescriptor sd = this.convertToStorageDescriptor(identifier, schema);
        table.setSd(sd);
    }

    private StorageDescriptor convertToStorageDescriptor(Identifier identifier, TableSchema schema) {
        StorageDescriptor sd = new StorageDescriptor();
        sd.setCols(schema.fields().stream().map(this::convertToFieldSchema).collect(Collectors.toList()));
        sd.setLocation(this.getDataTableLocation(identifier).toString());
        sd.setInputFormat(INPUT_FORMAT_CLASS_NAME);
        sd.setOutputFormat(OUTPUT_FORMAT_CLASS_NAME);
        SerDeInfo serDeInfo = new SerDeInfo();
        serDeInfo.setParameters(new HashMap());
        serDeInfo.setSerializationLib(SERDE_CLASS_NAME);
        sd.setSerdeInfo(serDeInfo);
        return sd;
    }

    private FieldSchema convertToFieldSchema(DataField dataField) {
        return new FieldSchema(dataField.name(), HiveTypeUtils.logicalTypeToTypeInfo(dataField.type()).getTypeName(), dataField.description());
    }

    private boolean paimonTableExists(Identifier identifier) {
        return this.paimonTableExists(identifier, true);
    }

    private boolean schemaFileExists(Identifier identifier) {
        return new SchemaManager(this.fileIO, this.getDataTableLocation(identifier)).latest().isPresent();
    }

    private boolean paimonTableExists(Identifier identifier, boolean throwException) {
        boolean isPaimonTable;
        Table table;
        try {
            table = this.client.getTable(identifier.getDatabaseName(), identifier.getObjectName());
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        catch (TException e) {
            throw new RuntimeException("Cannot determine if table " + identifier.getFullName() + " is a paimon table.", e);
        }
        boolean bl = isPaimonTable = HiveCatalog.isPaimonTable(table) || LegacyHiveClasses.isPaimonTable(table);
        if (!isPaimonTable && throwException) {
            throw new IllegalArgumentException("Table " + identifier.getFullName() + " is not a paimon table. It's input format is " + table.getSd().getInputFormat() + " and its output format is " + table.getSd().getOutputFormat());
        }
        return isPaimonTable;
    }

    private static boolean isPaimonTable(Table table) {
        return INPUT_FORMAT_CLASS_NAME.equals(table.getSd().getInputFormat()) && OUTPUT_FORMAT_CLASS_NAME.equals(table.getSd().getOutputFormat());
    }

    private SchemaManager schemaManager(Identifier identifier) {
        this.checkIdentifierUpperCase(identifier);
        return new SchemaManager(this.fileIO, this.getDataTableLocation(identifier)).withLock(this.lock(identifier));
    }

    private Lock lock(Identifier identifier) {
        if (!this.lockEnabled()) {
            return new Lock.EmptyLock();
        }
        HiveCatalogLock lock = new HiveCatalogLock(this.client, HiveCatalogLock.checkMaxSleep(this.hiveConf), HiveCatalogLock.acquireTimeout(this.hiveConf));
        return Lock.fromCatalog(lock, identifier);
    }

    static IMetaStoreClient createClient(HiveConf hiveConf, String clientClassName) {
        IMetaStoreClient client;
        Method getProxy = null;
        RuntimeException methodNotFound = new RuntimeException("Failed to find desired getProxy method from RetryingMetaStoreClient");
        for (Class<?>[] classes : GET_PROXY_PARAMS) {
            try {
                getProxy = RetryingMetaStoreClient.class.getMethod("getProxy", classes);
            }
            catch (NoSuchMethodException e) {
                methodNotFound.addSuppressed(e);
            }
        }
        if (getProxy == null) {
            throw methodNotFound;
        }
        try {
            client = (IMetaStoreClient)getProxy.invoke(null, hiveConf, tbl -> null, new ConcurrentHashMap(), clientClassName, true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return StringUtils.isNullOrWhitespaceOnly(hiveConf.get(HiveConf.ConfVars.METASTOREURIS.varname)) ? client : HiveMetaStoreClient.newSynchronizedClient((IMetaStoreClient)client);
    }

    public static HiveConf createHiveConf(@Nullable String hiveConfDir, @Nullable String hadoopConfDir) {
        Configuration hadoopConf = null;
        if (!StringUtils.isNullOrWhitespaceOnly(hadoopConfDir) && (hadoopConf = HiveCatalog.getHadoopConfiguration(hadoopConfDir)) == null) {
            String possiableUsedConfFiles = "core-site.xml | hdfs-site.xml | yarn-site.xml | mapred-site.xml";
            throw new RuntimeException("Failed to load the hadoop conf from specified path:" + hadoopConfDir, new FileNotFoundException("Please check the path none of the conf files (" + possiableUsedConfFiles + ") exist in the folder."));
        }
        if (hadoopConf == null) {
            hadoopConf = new Configuration();
        }
        LOG.info("Setting hive conf dir as {}", (Object)hiveConfDir);
        if (hiveConfDir != null) {
            HiveConf.setHiveSiteLocation(null);
            HiveConf.setLoadMetastoreConfig((boolean)false);
            HiveConf.setLoadHiveServer2Config((boolean)false);
            HiveConf hiveConf = new HiveConf(hadoopConf, HiveConf.class);
            org.apache.hadoop.fs.Path hiveSite = new org.apache.hadoop.fs.Path(hiveConfDir, HIVE_SITE_FILE);
            if (!hiveSite.toUri().isAbsolute()) {
                hiveSite = new org.apache.hadoop.fs.Path(new File(hiveSite.toString()).toURI());
            }
            try (FSDataInputStream inputStream = hiveSite.getFileSystem(hadoopConf).open(hiveSite);){
                hiveConf.addResource((InputStream)inputStream, hiveSite.toString());
                HiveCatalog.isEmbeddedMetastore(hiveConf);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load hive-site.xml from specified path:" + hiveSite, e);
            }
            hiveConf.addResource(hiveSite);
            return hiveConf;
        }
        return new HiveConf(hadoopConf, HiveConf.class);
    }

    public static boolean isEmbeddedMetastore(HiveConf hiveConf) {
        return StringUtils.isNullOrWhitespaceOnly(hiveConf.getVar(HiveConf.ConfVars.METASTOREURIS));
    }

    public static Configuration getHadoopConfiguration(String hadoopConfDir) {
        if (new File(hadoopConfDir).exists()) {
            File mapredSite;
            File yarnSite;
            File hdfsSite;
            ArrayList<File> possiableConfFiles = new ArrayList<File>();
            File coreSite = new File(hadoopConfDir, "core-site.xml");
            if (coreSite.exists()) {
                possiableConfFiles.add(coreSite);
            }
            if ((hdfsSite = new File(hadoopConfDir, "hdfs-site.xml")).exists()) {
                possiableConfFiles.add(hdfsSite);
            }
            if ((yarnSite = new File(hadoopConfDir, "yarn-site.xml")).exists()) {
                possiableConfFiles.add(yarnSite);
            }
            if ((mapredSite = new File(hadoopConfDir, "mapred-site.xml")).exists()) {
                possiableConfFiles.add(mapredSite);
            }
            if (possiableConfFiles.isEmpty()) {
                return null;
            }
            Configuration hadoopConfiguration = new Configuration();
            for (File confFile : possiableConfFiles) {
                hadoopConfiguration.addResource(new org.apache.hadoop.fs.Path(confFile.getAbsolutePath()));
            }
            return hadoopConfiguration;
        }
        return null;
    }
}

