/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.CharType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.VarCharType;

public class HiveTypeUtils {
    public static TypeInfo logicalTypeToTypeInfo(DataType logicalType) {
        switch (logicalType.getTypeRoot()) {
            case BOOLEAN: {
                return TypeInfoFactory.booleanTypeInfo;
            }
            case TINYINT: {
                return TypeInfoFactory.byteTypeInfo;
            }
            case SMALLINT: {
                return TypeInfoFactory.shortTypeInfo;
            }
            case INTEGER: {
                return TypeInfoFactory.intTypeInfo;
            }
            case BIGINT: {
                return TypeInfoFactory.longTypeInfo;
            }
            case FLOAT: {
                return TypeInfoFactory.floatTypeInfo;
            }
            case DOUBLE: {
                return TypeInfoFactory.doubleTypeInfo;
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)logicalType;
                return TypeInfoFactory.getDecimalTypeInfo((int)decimalType.getPrecision(), (int)decimalType.getScale());
            }
            case CHAR: {
                CharType charType = (CharType)logicalType;
                return TypeInfoFactory.getCharTypeInfo((int)charType.getLength());
            }
            case VARCHAR: {
                VarCharType varCharType = (VarCharType)logicalType;
                if (varCharType.getLength() == Integer.MAX_VALUE) {
                    return TypeInfoFactory.stringTypeInfo;
                }
                return TypeInfoFactory.getVarcharTypeInfo((int)varCharType.getLength());
            }
            case BINARY: 
            case VARBINARY: {
                return TypeInfoFactory.binaryTypeInfo;
            }
            case DATE: {
                return TypeInfoFactory.dateTypeInfo;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return TypeInfoFactory.timestampTypeInfo;
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)logicalType;
                return TypeInfoFactory.getListTypeInfo((TypeInfo)HiveTypeUtils.logicalTypeToTypeInfo(arrayType.getElementType()));
            }
            case MAP: {
                MapType mapType = (MapType)logicalType;
                return TypeInfoFactory.getMapTypeInfo((TypeInfo)HiveTypeUtils.logicalTypeToTypeInfo(mapType.getKeyType()), (TypeInfo)HiveTypeUtils.logicalTypeToTypeInfo(mapType.getValueType()));
            }
            case ROW: {
                RowType rowType = (RowType)logicalType;
                List fieldNames = rowType.getFields().stream().map(DataField::name).collect(Collectors.toList());
                List typeInfos = rowType.getFields().stream().map(DataField::type).map(HiveTypeUtils::logicalTypeToTypeInfo).collect(Collectors.toList());
                return TypeInfoFactory.getStructTypeInfo(fieldNames, typeInfos);
            }
        }
        throw new UnsupportedOperationException("Unsupported logical type " + logicalType.asSQLString());
    }
}

