/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.paimon.io.DataInputDeserializer;
import org.apache.paimon.io.DataOutputSerializer;

public class SerializableHiveConf
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient HiveConf conf;

    public SerializableHiveConf(HiveConf conf) {
        this.conf = conf;
    }

    public HiveConf conf() {
        return this.conf;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        DataOutputSerializer ser = new DataOutputSerializer(256);
        this.conf.write((DataOutput)ser);
        out.writeInt(ser.length());
        out.write(ser.getSharedBuffer(), 0, ser.length());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] data = new byte[in.readInt()];
        in.readFully(data);
        DataInputDeserializer deser = new DataInputDeserializer(data);
        this.conf = new HiveConf();
        try {
            this.conf.readFields((DataInput)deser);
        }
        catch (IOException e) {
            throw new IOException("Could not deserialize HiveConf, the serialized and de-serialized don't match.", e);
        }
    }
}

