/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.paimon.KeyValue;
import org.apache.paimon.KeyValueSerializer;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.format.FileFormat;
import org.apache.paimon.format.FileStatsExtractor;
import org.apache.paimon.format.FormatWriterFactory;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.io.KeyValueDataFileWriter;
import org.apache.paimon.io.RollingFileWriter;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.FileStorePathFactory;

public class KeyValueFileWriterFactory {
    private final FileIO fileIO;
    private final long schemaId;
    private final RowType keyType;
    private final RowType valueType;
    private final FormatWriterFactory writerFactory;
    @Nullable
    private final FileStatsExtractor fileStatsExtractor;
    private final DataFilePathFactory pathFactory;
    private final long suggestedFileSize;
    private final Map<Integer, String> levelCompressions;
    private final String fileCompression;

    private KeyValueFileWriterFactory(FileIO fileIO, long schemaId, RowType keyType, RowType valueType, FormatWriterFactory writerFactory, @Nullable FileStatsExtractor fileStatsExtractor, DataFilePathFactory pathFactory, long suggestedFileSize, Map<Integer, String> levelCompressions, String fileCompression) {
        this.fileIO = fileIO;
        this.schemaId = schemaId;
        this.keyType = keyType;
        this.valueType = valueType;
        this.writerFactory = writerFactory;
        this.fileStatsExtractor = fileStatsExtractor;
        this.pathFactory = pathFactory;
        this.suggestedFileSize = suggestedFileSize;
        this.levelCompressions = levelCompressions;
        this.fileCompression = fileCompression;
    }

    public RowType keyType() {
        return this.keyType;
    }

    public RowType valueType() {
        return this.valueType;
    }

    @VisibleForTesting
    public DataFilePathFactory pathFactory() {
        return this.pathFactory;
    }

    public RollingFileWriter<KeyValue, DataFileMeta> createRollingMergeTreeFileWriter(int level) {
        return new RollingFileWriter<KeyValue, DataFileMeta>(() -> this.createDataFileWriter(this.pathFactory.newPath(), level, this.getCompression(level)), this.suggestedFileSize);
    }

    private String getCompression(int level) {
        if (null == this.levelCompressions) {
            return this.fileCompression;
        }
        return this.levelCompressions.getOrDefault(level, this.fileCompression);
    }

    public RollingFileWriter<KeyValue, DataFileMeta> createRollingChangelogFileWriter(int level) {
        return new RollingFileWriter<KeyValue, DataFileMeta>(() -> this.createDataFileWriter(this.pathFactory.newChangelogPath(), level, this.getCompression(level)), this.suggestedFileSize);
    }

    private KeyValueDataFileWriter createDataFileWriter(Path path, int level, String compression) {
        KeyValueSerializer kvSerializer = new KeyValueSerializer(this.keyType, this.valueType);
        return new KeyValueDataFileWriter(this.fileIO, this.writerFactory, path, kvSerializer::toRow, this.keyType, this.valueType, this.fileStatsExtractor, this.schemaId, level, compression);
    }

    public void deleteFile(String filename) {
        this.fileIO.deleteQuietly(this.pathFactory.toPath(filename));
    }

    public static Builder builder(FileIO fileIO, long schemaId, RowType keyType, RowType valueType, FileFormat fileFormat, FileStorePathFactory pathFactory, long suggestedFileSize) {
        return new Builder(fileIO, schemaId, keyType, valueType, fileFormat, pathFactory, suggestedFileSize);
    }

    public static class Builder {
        private final FileIO fileIO;
        private final long schemaId;
        private final RowType keyType;
        private final RowType valueType;
        private final FileFormat fileFormat;
        private final FileStorePathFactory pathFactory;
        private final long suggestedFileSize;

        private Builder(FileIO fileIO, long schemaId, RowType keyType, RowType valueType, FileFormat fileFormat, FileStorePathFactory pathFactory, long suggestedFileSize) {
            this.fileIO = fileIO;
            this.schemaId = schemaId;
            this.keyType = keyType;
            this.valueType = valueType;
            this.fileFormat = fileFormat;
            this.pathFactory = pathFactory;
            this.suggestedFileSize = suggestedFileSize;
        }

        public KeyValueFileWriterFactory build(BinaryRow partition, int bucket, Map<Integer, String> levelCompressions, String fileCompression) {
            RowType recordType = KeyValue.schema(this.keyType, this.valueType);
            return new KeyValueFileWriterFactory(this.fileIO, this.schemaId, this.keyType, this.valueType, this.fileFormat.createWriterFactory(recordType), this.fileFormat.createStatsExtractor(recordType).orElse(null), this.pathFactory.createDataFilePathFactory(partition, bucket), this.suggestedFileSize, levelCompressions, fileCompression);
        }
    }
}

